
#include "defs.h"
#include "mp.e"
#include "real.e"
#include "error.e"

t_real
real_arctanh WITH_2_ARGS(
	t_handle,		r,
	t_real,		t
)
/*
** Returns arctanh( t ).
*/
{
	mp_float	tf, resf, t1, t2;

        if ( ! real_inside_bounds( r, t, ring_minus1( r ), FALSE, ring_one( r ), FALSE ))
        {
                error_runtime (ERR_DOMAIN);
        }

	real_make_mp( t, tf );
	t1 = mp_alloc( real_base, real_beta_prec( r ));
	t2 = mp_alloc( real_base, real_beta_prec( r ));
	resf = mp_alloc( real_base, real_beta_prec( r ));

	mp_add_int( tf, 1, t1 );
	mp_add_int( tf, -1, t2 );
	mp_neg( t2, t2 );
	mp_div( t1, t2, t1 );
	mp_log( t1, t1 );
	mp_div_int( t1, 2, resf );

	mp_delete_float( t1 );
	mp_delete_float( t2 );

	return mp_to_real( resf );
}
