
#include "defs.h"
#include "mp.e"
#include "real.e"
#include "error.e"

t_real
real_arccosh WITH_2_ARGS(
	t_handle,		r,
	t_real,		t
)
/*
** Returns arccosh( t ).
*/
{
	mp_float	tf, resf, t1;

	if ( ! real_inside_bounds( r, t, ring_one( r ), TRUE, 0, TRUE ))
	{
		error_runtime (ERR_DOMAIN);
	}

	real_make_mp( t, tf );
	t1 = mp_alloc( real_base, real_beta_prec( r ));
	resf = mp_alloc( real_base, real_beta_prec( r ));

	mp_mul( tf, tf, t1 );
	mp_add_int( t1, -1, t1 );
	mp_sqrt( t1, t1 );
	mp_add( t1, tf, t1 );
	mp_log( t1, resf );

	mp_delete_float( t1 );

	return mp_to_real( resf );
}
