
#include "defs.h"
#include "mp.e"
#include "mp.h"
#include "real.e"

t_real
real_abs WITH_2_ARGS(
	t_handle,		r,
	t_real,		a
)
/*
Returns the absolute value of a.
*/
{
    mp_float	f, af;
    mp_ptr_type	ap;

    real_make_mp(a, af);
    ap = mp_ptr(af);
    if ( mp_sign( ap ) >= 0 )
    {
	return real_incref( a );
    }

    f = mp_alloc(real_base, real_beta_prec(r));
    mp_neg(af, f);

    return mp_to_real(f);
}

