#include "defs.h"
#include "integer.e"
#include "q.h"

void
q_simplify WITH_1_ARG(
	rational,	r
)
/*
Simplifies r so that its numerator and denominator have no common factors.
*/
{
    block_declarations;
    integer_big		numer, denom, gcd;

    if (r == 0)
    {
	return;
    }

    denom = q_denom(r);

    if (denom == 1 || denom == -1)
    {
	return;
    }

    numer = q_numer(r);

    if (numer == denom)
    {
	if (numer != 1)
	{
	    integer_delref(numer);
	    integer_delref(denom);
	    q_numer(r) = q_denom(r) = 1;
	}
	return;
    }

    gcd = integer_gcd(numer, denom);

    if (gcd != 1 && gcd != -1)
    {
	q_numer(r) = integer_div(numer, gcd);
	q_denom(r) = integer_div(denom, gcd);
	integer_delref(numer);
	integer_delref(denom);
	integer_delref(gcd);
    }
}

