
#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"
#include "prime_cert.e"
#include "prime_cert.h"

Void
prime_cert_print WITH_1_ARG(
    prime_cert_handle,    cert
)
/*
** Prints out the primality certificate. Used for testing.
*/
{
    t_int	i;
    t_int	max;

    max = prime_cert_curr_length(cert);
    for (i = 0 ; i < max ; i++)
    {
	integer_write( prime_cert_prime(cert,i) );
	cay_print(" ");
	integer_write( prime_cert_div(cert,i) );
	cay_print(" ");
	integer_write( prime_cert_base(cert,i) );
	cay_print("\n");
    }
}
