
#include "defs.h"
#include "integer.e"
#include "prime_cert.e"
#include "prime_cert.h"

prime_cert_handle
prime_cert_alloc WITH_1_ARG(
    prime_cert_length,    len
)
/*
** Allocate and initialize a block for a primality certificate with room
** for len elements.
*/
{
    prime_cert_handle h;

    h = mem_alloc_words_zero( prime_cert_required_space( len ) );
    block_init( h, PRIME_CERT_BLOCK_TYPE );
    prime_cert_curr_length( h ) = 0;

    return h;
}

