#include "defs.h"
#include "zm.e"
#include "poly.h"
#include "error.e"
 
t_poly
poly_zm_scalar_div (pring, elt1, coef)
t_handle       pring;
t_poly      elt1;
t_int          coef;
/*
 * Find inverse if it exists and call modpoly_integer_mult.
 */
{
	block_declarations;
	integer_big    inv, zmod;
	t_poly      res;

	zmod = zm_modulus (m_poly_coeff_ring (pring));
	if (!zm_unit (zmod, coef))
		error_runtime (ERR_DIVIDE_BY_NON_UNIT, coef);
	inv = zm_inverse (zmod, coef);
	res = modpoly_integer_mult (pring, zmod, elt1, inv);
	integer_delref (inv);
	return res;
}

