
#include "defs.h"
#include "integer.e"
#include "poly.h"

t_poly
poly_z_negate WITH_2_ARGS(
    t_handle,    pring,
    t_poly,   apoly
)
/*
*        IPOLY_NEGATE : integral polynomial negative.
*        apoly is an integral polynomial. returns -apoly
*/
{
    t_handle           resph;           /* t_handle to respoly  */
    t_handle           aph;             /* t_handle to apoly    */
    t_poly        acoefft;
    t_int    termno;          /* loop counter       */
    t_int    nterms;          /* no. terms in apoly */

    if ( m_poly_const( apoly ) )
    {
        /* apoly is constant */
        return  integer_negate( apoly );
    }

    /* general case: non-trivial polynomial */

    aph = m_poly_poly_to_handle( apoly );
    nterms = m_poly_nterms( aph );

    m_poly_create_empty(&resph, m_poly_princvar (aph),
                                        m_poly_least_pvar (aph), nterms);

    /* negate coefficients term by term */

    for ( termno = 0;termno < nterms; termno++ )
    {
        /* leave expts unchanged */

        m_poly_expt( resph, termno ) = m_poly_expt( aph, termno );
        acoefft = m_poly_coefft( aph, termno );

        if ( m_poly_not_const (acoefft))
            m_poly_coefft (resph, termno) = poly_z_negate (pring, acoefft);
        else
            m_poly_coefft (resph, termno) = integer_negate (acoefft);
    }

    return  m_poly_handle_to_poly( resph );

} /* poly_z_negate() */

