#include "defs.h"
#include "poly.h"
#include "poly_mat.h"
#include "integer.e"
#include "error.e"

public t_matrix poly_mat_mult( a, b, pdig )
t_matrix a;
t_matrix b;
t_int pdig;
/*
** Multiplies matrix a by matrix b, both over coefficient ring cring.
** a is (am X an), matb is (bm X bn).
** Result to be stored in *pc (am X bn) if allocated, otherwise *pc assigned.
*/
{
	block_declarations;
	register t_int	i;
	register t_int	j;
	register t_int	k;
	register integer_big	s;
	register t_int	am;
	register t_int	an;
	register t_int	bm;
	register t_int	bn;
	t_matrix	mata;
	t_matrix	matb;
	t_matrix	matc;
	t_int	temp1;
	t_int	temp2;

	am = m_poly_mat_row(a);		an = m_poly_mat_col(a);
	bm = m_poly_mat_row(b);		bn = m_poly_mat_col(b);

	if (an != bm)
		error_internal("Incompatible matrices for multiplication, %d,%d by %d,%d\n", am, an, bm, bn);


	mata = a;
	matb = b;
	matc = poly_mat_new(am, bn);
	

	/*
	 * i represents the row number of matc
	 */
	for (i = 1; i <= am; ++i)
	{
		/*
		 * j represents the column number of matc
		 */
		for (j = 1; j <= bn; ++j)
		{
			s = 0;
			for (k = 1; k <= an; ++k)
			{
				temp1 = s;
				temp2 = (m_poly_mat_elt(mata, i, k)* m_poly_mat_elt(matb, k, j)) % pdig;
				s = (temp1 + temp2) % pdig;
				integer_delref(temp1 );
				integer_delref(temp2 );
			}
			m_poly_mat_elt(matc, i, j) = s;
		}
	}

	return matc;
}


public t_void poly_mat_delete( m )
t_matrix m;
{
	mem_delete_hptr(&m);
	return;
}
