#include "poly.h"

t_poly
poly_lcm  (pring, x, y)
t_handle	pring;
t_poly		x, y;
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	return poly_lcm_crf(&context, x, y);
}

t_poly
poly_lcm_crf(context, x, y)
t_poly_ctx	context;
t_poly		x, y;
{
	t_poly          s, t, u, v;
        t_poly          g, temp, rem, lcm;

	DENY(m_poly_ctx_quotient(context));

	poly_xgcd_crf(context, x, y, &g, &s, &t, &u, &v);
	poly_elt_delete_crf(context, &s);
        poly_elt_delete_crf(context, &t);
        poly_elt_delete_crf(context, &u);
        poly_elt_delete_crf(context, &v);

	temp = poly_mult_crf(context, x, y);
	poly_quot_rem_crf(context, temp, g, &lcm, &rem);
	ASSERT(poly_is_zero_crf(context, rem));
        poly_elt_delete_crf(context, &temp);
        poly_elt_delete_crf(context, &g);
        poly_elt_delete_crf(context, &rem);
	
	return lcm;
}

t_void
poly_xgcd  (pring, x, y, gcd, s, t, u, v)
t_handle	pring;
t_poly		x, y, *gcd, *s, *t, *u, *v;
/*
** Calls poly_xgcd_crf
*/
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	poly_xgcd_crf(&context, x, y, gcd, s, t, u, v);
}


t_void
poly_xgcd_crf  (context, x, y, gcd, s, t, u, v)
t_poly_ctx	context;
t_poly		x, y, *gcd, *s, *t, *u, *v;
/*
** xgcd for univariate polynomials over a field.
** computes the gcd = gcd(x,y) and
** polynomials s and t such that
** gcd = x*s + y*t
** 0  = x*u + y*v
** and s*v - u*t = 1.
**
** See the Extended Euclidean algorithm in Knuth 4.5.2
*/
{
	t_handle	xph;
	t_poly		a[2], b[2], c[2];
	t_poly		one, zero;
	t_poly		q, r;
	t_poly		temp, tempa, tempb;
	t_int		j, k;
	t_handle	cring, o;
	t_handle	lc, lcinv;
	t_pfh		elt_slash;
	/* abc is a pair of 3-vectors. abc(j) is always the x vector.
	** abc(k) is always the y vector. Start with j = 0, k = 1.
	*/

	xph = m_poly_poly_to_handle(x);
	ASSERT(m_poly_univariate(xph));
	cring = m_poly_ctx_cring(context);

	one = poly_constant_poly_crf(context, x, o = ring_one(cring));
	zero = poly_zero_poly_crf(context, x);
	a[0] = poly_elt_incref_crf(context, one);
	b[0] = poly_elt_incref_crf(context, zero);
	c[0] = poly_elt_incref_crf(context, x);
	a[1] = poly_elt_incref_crf(context, zero);
	b[1] = poly_elt_incref_crf(context, one);
	c[1] = poly_elt_incref_crf(context, y);

	j = 0;

	for (;;)
	{
		k = 1 - j;
		if (poly_eq_crf(context, c[k], zero))
			break;

		poly_quot_rem_crf(context, c[j], c[k], &q, &r);

		tempa = poly_mult_crf(context, q, a[k]);
		temp = a[j];
		a[j] = poly_subtract_crf(context, a[j] , tempa);
		poly_elt_delete_crf(context, &temp);
		poly_elt_delete_crf(context, &tempa);

		tempb = poly_mult_crf(context, q, b[k]);
		temp = b[j];
		b[j] = poly_subtract_crf(context, b[j] , tempb);
		poly_elt_delete_crf(context, &temp);
		poly_elt_delete_crf(context, &tempb);


		poly_elt_delete_crf(context, &(c[j]));
		c[j] = r;
		poly_elt_delete_crf(context, &q);

		/*
		** "Call" the Euclidean algorithm again 
		** with the vectors swapped.
		*/
		j = k;
	}

	/*
	* we have finished.
	*/
	poly_elt_delete_crf(context, &one);
	poly_elt_delete_crf(context, &zero);

	lc = poly_lbase_coefft_crf(context, c[j]);
	elt_slash = m_poly_ctx_elt_slash(context);
	lcinv = (* elt_slash)(cring, o, lc);
	ring_elt_delete(cring, &o);
	*s = poly_scalar_mult_crf(context, a[j], lcinv);
	*t = poly_scalar_mult_crf(context, b[j], lcinv);
	*gcd = poly_scalar_mult_crf(context, c[j], lcinv);

	*u = poly_scalar_mult_crf(context, a[k], lc);
	*v = poly_scalar_mult_crf(context, b[k], lc);
	ring_elt_delete(cring, &lc);
	ring_elt_delete(cring, &lcinv);
	poly_elt_delete_crf(context, a );
	poly_elt_delete_crf(context, b );
	poly_elt_delete_crf(context, c );
	poly_elt_delete_crf(context, (a + 1));
	poly_elt_delete_crf(context, (b + 1));
	poly_elt_delete_crf(context, (c + 1));
	return;

}
