#include "defs.h"
#include "mp.e"
#include "mp.h"


mp_float
mp_sub		WITH_3_ARGS(
	mp_float,	x,
	mp_float,	y,
	mp_float,	z
)
/*
Sets z = x - y and returns z.
*/
{
    mp_ptr_type		xp = mp_ptr(x), yp = mp_ptr(y), zp = mp_ptr(z);
    mp_sign_type	z_sign;


    DEBUG_BEGIN(DEBUG_OTHER);
    DEBUG_PRINTF_1("+sub {\n");
    DEBUG_1("x = ", xp);
    DEBUG_1("y = ", yp);

    if (xp == yp)
    {
	mp_set_sign(zp, 0);

	DEBUG_PRINTF_1("x == y, so z = 0");
	DEBUG_PRINTF_1("-} sub\n");
	DEBUG_END();

	return z;
    }

    mp_change_up();
    mp_set_sign(yp, -mp_sign(yp));

    mp_add(x, y, z);

    /*
    Be careful in case that y is the same as z.
    */

    if (mp_has_changed())
    {
	yp = mp_ptr(y);
	zp = mp_ptr(z);
    }

    z_sign = mp_sign(zp);
    mp_set_sign(yp, -mp_sign(yp));
    mp_set_sign(zp, z_sign);

    mp_change_down();

    DEBUG_1("-} z = ", zp);
    DEBUG_END();

    return z;
}


mp_float
mp_neg		WITH_2_ARGS(
	mp_float,	x,
	mp_float,	y
)
/*
Sets y = -x and returns y.
*/
{
    mp_ptr_type		xp = mp_ptr(x), yp = mp_ptr(y);


    if (xp != yp)
	mp_copy_ptr(xp, yp);

    mp_set_sign(yp, -mp_sign(yp));

    return y;
}
