#include "defs.h"
#include "debug.e"
#include "mp.e"
#include "mp.h"


#define mp_float_t(f)	mp_t(mp_ptr(f))
#define mp_acc_t(f)	mp_t(mp_acc_float_ptr(f))


t_void
mp_poly		WITH_5_ARGS(
	mp_int,		n,
	mp_vector,	Ar,
	mp_vector,	Ai,
	mp_vector,	Xr,
	mp_vector,	Xi
)
/*
*/
{
    mp_ptr_type		ip = mp_ptr(mp_vector_el(Ar, 0));
    mp_base_type	b;
    mp_length		t, full_t, save_t, last_t, it0, orig_t;
    mp_int		i, k;
    mp_acc_float	sumr, sumi, prodr, prodi;
    mp_acc_float	temp1, temp2, temp3, Q;

    b = mp_b(ip);
    orig_t = t = mp_t(ip);

    full_t = t + 1 + mp_guard_digits(t, b);
    full_t = t;

    mp_acc_float_alloc_4(b, full_t, sumr, sumi, prodr, prodi);
    mp_acc_float_alloc_4(b, full_t, temp1, temp2, temp3, Q);

    t = 13 - 2 * b;

    if (full_t < 5)
	t = full_t;
    else
	t = 5;

    it0 = (t + 5) / 2;
    last_t = -1;

    do
    {
	if (t == full_t)
	{
	    mp_acc_t(Q) = t;
	    mp_int_to_mp(0, Q);
	}

	mp_float_t(mp_vector_el(Ar, n)) = t;
	if (Ai)
	    mp_float_t(mp_vector_el(Ai, n)) = t;
	mp_acc_t(sumr) = mp_acc_t(prodr) = t;
	mp_acc_t(sumi) = mp_acc_t(prodi) = t;
	mp_acc_t(temp1) = mp_acc_t(temp2) = mp_acc_t(temp3) = t;

	for (i = 0; i < n; i++)
	{
	    mp_copy(mp_vector_el(Ar, n), sumr);
	    mp_copy(sumr, prodr);

	    if (Ai)
	    {
		mp_float_t(mp_vector_el(Ai, n)) = t;
		mp_copy(mp_vector_el(Ai, n), sumi);
		mp_copy(sumi, prodi);
	    }
	    else
	    {
		mp_int_to_mp(0, sumi);
		mp_int_to_mp(0, prodi);
	    }

	    mp_float_t(mp_vector_el(Xr, i)) = t;
	    mp_float_t(mp_vector_el(Xi, i)) = t;

	    for (k = 0; k < n; k++)
	    {
		if (i == 0)
		{
		    mp_float_t(mp_vector_el(Ar, n - k - 1)) = t;
		    if (Ai)
			mp_float_t(mp_vector_el(Ai, n - k - 1)) = t;
		}

		mp_mul(sumr, mp_vector_el(Xr, i), temp1);
		mp_mul(sumi, mp_vector_el(Xi, i), temp2);
		mp_sub_eq(temp1, temp2);
		mp_mul(sumr, mp_vector_el(Xi, i), temp2);
		mp_add(temp1, mp_vector_el(Ar, n - k - 1), sumr);
		mp_mul(sumi, mp_vector_el(Xr, i), sumi);
		mp_add_eq(sumi, temp2);
		if (Ai)
		    mp_add_eq(sumi, mp_vector_el(Ai, n - k - 1));

		if (k != i)
		{
		    if (i == 0)
		    {
			mp_float_t(mp_vector_el(Xr, k)) = t;
			mp_float_t(mp_vector_el(Xi, k)) = t;
		    }

		    mp_sub(mp_vector_el(Xr, i), mp_vector_el(Xr, k), temp1);
		    mp_sub(mp_vector_el(Xi, i), mp_vector_el(Xi, k), temp2);
		    mp_mul(prodr, temp2, temp3);
		    mp_mul_eq(prodr, temp1);
		    mp_mul_eq(temp2, prodi);
		    mp_sub_eq(prodr, temp2);
		    mp_mul_eq(prodi, temp1);
		    mp_add_eq(prodi, temp3);
		}
	    }

	    mp_mul(prodr, prodr, temp1);
	    mp_mul(prodi, prodi, temp2);
	    mp_add(temp1, temp2, temp3);
	    mp_mul(sumr, prodr, temp1);
	    mp_mul(sumi, prodi, temp2);
	    mp_add_eq(temp1, temp2);
	    mp_div_eq(temp1, temp3);
	    mp_sub_eq(mp_vector_el(Xr, i), temp1);
	    mp_mul(sumi, prodr, temp1);
	    mp_mul(sumr, prodi, temp2);
	    mp_sub_eq(temp1, temp2);
	    mp_div_eq(temp1, temp3);
	    mp_sub_eq(mp_vector_el(Xi, i), temp1);

	    /*
	    update Q:
	    */

	    if (t == full_t)
	    {
		mp_mul_eq(sumr, sumr);
		mp_mul_eq(sumi, sumi);
		mp_add(sumr, sumi, temp1);
		mp_div_eq(temp1, temp3);
		mp_add_eq(Q, temp1);
	    }

	}


	/*
	The following loop computes the next value of t to use.  Because
	Newton's method has 2nd order convergence, we can almost double
	t each time.
	*/

	last_t = t;
	if (t < full_t)
	{
	    t = full_t;

	    do
	    {
		save_t = t;
		t = (t + it0) / 2;
	    } while (t > last_t);

	    t = save_t;
	}

#if 0
{
    int w;
    printf("\nnext: ");
    mp_print(Q);
    puts("");
    for (w = 0; w < n; w++)
    {
	mp_print(mp_vector_el(Xr, w));
	printf(", ");
	mp_print(mp_vector_el(Xi, w));
	printf("\n");
    }
}

    if (last_t == full_t)
    {
	printf("Q = ");
	mp_print(Q);
	puts("");
    }
#endif
    } while (last_t < full_t || !mp_is_zero(mp_acc_float_ptr(Q))
		&& mp_expt(mp_acc_float_ptr(Q)) > -full_t);


    mp_acc_float_delete(Q);
    mp_acc_float_delete(temp3);
    mp_acc_float_delete(temp2);
    mp_acc_float_delete(temp1);
    mp_acc_float_delete(prodi);
    mp_acc_float_delete(prodr);
    mp_acc_float_delete(sumi);
    mp_acc_float_delete(sumr);
}


/* Care of Count JS: don't make this more accurate!!!! */
#define PI 3.0
 

void
mp_init_roots	(n, Xr, Xi)
mp_int		n;
mp_vector	Xr;
mp_vector	Xi;
{
    double	r, i, r1, i1, temp, cos(), sin();
    mp_int	k;

    mp_int_to_mp(1, mp_vector_el(Xr, 0));
    mp_int_to_mp(0, mp_vector_el(Xi, 0));

	IF_DEBUG_FLAG(DEBUG_MP,
	{
		io_printf("mp_init_roots : n = %i\n",n);
	}
	);
	r1 = (r = cos(2 * PI / n));
	i1 = (i = sin(2 * PI / n));

	for (k = 1; k < n; k++)
	{
		IF_DEBUG_FLAG(DEBUG_MP,
		{
		io_printf ("mp_init_roots (loop %i): r = %f, i = %f\n",k, r, i);
		}
		);
		conv_double_to_mp(r, mp_vector_el(Xr, k));
		conv_double_to_mp(i, mp_vector_el(Xi, k));

		temp = r * r1 - i * i1;
		i = r * i1 + i * r1;
		r = temp;
	}
}
