#include "defs.h"
#include "mp.e"
#include "mp.h"

mp_length
mp_priv_guard_digits	WITH_2_ARGS(
	mp_int,		n,
	mp_base_type,	b
)
/*
This function (called mpgd in Brent) is useful for computing the number of
guard digits required for various multiple-precision calculations.
It returns the ceiling of the log to the base b of int_max(1, int_abs(n));
i.e. the minimum value of j such that b^j >= int_abs(n) (with j >= 0).  
*/
{
    mp_length		j;
    mp_int		k;

    DEBUG_BEGIN(DEBUG_OTHER);
    DEBUG_PRINTF_1("+guard_digits {\n");
    DEBUG_PRINTF_3("n = %d, b = %d\n", n, b);

    if (b < 2)
	mp_error("mp_guard_digits: illegal base b = %d", b);

    j = 0;
    k = int_abs(n) - 1;

    while (k > 0)
    {
	j++;
	k /= b;
    }

    DEBUG_PRINTF_2("-} j = %d\n", j);
    DEBUG_END();

    return j;
}


mp_length
mp_priv_extra_guard_digits	WITH_2_ARGS(
	mp_int,		n,
	mp_base_type,	b
)
/*
Returns 1 + mp_guard_digits(100 * n, b) which can be added to t.  The base is
just passed on to mp_guard_digits.
*/
{
    DEBUG_BEGIN(DEBUG_OTHER);
    DEBUG_PRINTF_2("extra_guard_digits (%d):\n", n);

    DEBUG_END();
    return n >= MAX_INT / 100? mp_guard_digits(n, b) + mp_guard_digits(100, b):
			       mp_guard_digits(100 * n, b);
}
