#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "zm.e"

t_poly
modpoly_negate WITH_3_ARGS(
        t_handle,       pring,
        integer_big,    mdig,
        t_poly,      apoly
)
/*
** modpoly_negate : modular integral polynomial negative.
** apoly is an integral polynomial, mdig modulus. returns -apoly mod mdig
*/
{
    t_handle           resph;
    t_handle           aph;
    t_poly        acoefft;
    t_int    termno;
    t_int    nterms;

    if ( m_poly_const( apoly ) )
    {
        return  modint_negate( mdig, apoly );
    }

    /* general case: non-trivial polynomial */

    aph = m_poly_poly_to_handle( apoly );
    nterms = m_poly_nterms( aph );

    m_poly_create_empty( &resph, m_poly_princvar (aph),
                                       m_poly_least_pvar (aph), nterms );

    /* negate coefficients term by term */

    if (m_poly_univariate (aph))
    {
        for ( termno = 0;termno < nterms; termno++ )
        {
            /* leave expts unchanged */

            m_poly_expt( resph, termno ) = m_poly_expt( aph, termno );
            acoefft = m_poly_coefft( aph, termno );
            m_poly_coefft( resph, termno ) = modint_negate( mdig, acoefft );
        }
    }
    else
    {
        for ( termno = 0;termno < nterms; termno++ )
        {
            /* leave expts unchanged */

            m_poly_expt( resph, termno ) = m_poly_expt( aph, termno );
            acoefft = m_poly_coefft( aph, termno );
            m_poly_coefft( resph, termno ) =
                                modpoly_negate( pring, mdig, acoefft );
        }
    }

    return  m_poly_handle_to_poly( resph ); 
}

