#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "zm.e"
#include "error.e"

/*
 * SAC MIPPR
 */

t_poly
modpoly_mult WITH_4_ARGS(
    t_handle,       pring,
    integer_big,    mdig,
    t_poly,      apoly,
    t_poly,      bpoly
)
/*
** MODPOLY_MULT: modular polynomial product.
** apoly, bpoly are polynomials over Zmdig,
** returns : ( apoly * bpoly ) mod mdig.
*/
{
    block_declarations;
    t_handle           aph;
    t_handle           bph;
    t_handle           adashph;
    t_poly        adashpoly;
    t_poly        respoly;
    t_poly        bcoefft;
    t_int    bexpt;
    t_int    i;
    t_int    j;
    t_int    aterms;
    t_int    bterms;
    t_poly        temp;



    if (poly_z_is_zero_poly (pring, apoly))
        return m_modpoly_incref (pring, apoly);
	
    if (poly_z_is_zero_poly (pring, bpoly))
        return m_modpoly_incref (pring, bpoly);

    if ( m_poly_const( apoly ))
    {
#ifdef DEBUG
        if (m_poly_not_const (bpoly))
        {
            error_internal ("modpoly_mult: polys not lifted\n");
            return 0;
        }
#endif /* DEBUG */
        return modint_mult( mdig, apoly, bpoly );
    }

#ifdef DEBUG
    if (m_poly_const (bpoly))
    {
        error_internal ("modpoly_mult: polys not lifted\n");
        return 0;
    }
#endif /* DEBUG */

    /* both polynomials non_trivial */

    bph = m_poly_poly_to_handle( bpoly );
    aph = m_poly_poly_to_handle( apoly );

#ifdef DEBUG
    if ((m_poly_princvar (aph)   != m_poly_princvar (bph))
     || (m_poly_least_pvar (aph) != m_poly_least_pvar (bph)))
    {
        error_internal ("modpoly_mult: polys not lifted\n");
        return 0;
    }
#endif /* DEBUG */

    bterms = m_poly_nterms( bph );
    aterms = m_poly_nterms( aph );

    /* apoly, bpoly in same principal variable */

    /* term by term of bpoly apply multiplication by apoly  */
    /* then add resulting polynomials to obtain product.    */

    /* adashph REUSED... dangerous, but improves performance markedly */

    m_poly_create_empty( &adashph, m_poly_princvar( aph ),
                                       m_poly_least_pvar (aph), aterms );
    adashpoly = m_poly_handle_to_poly( adashph );

    for ( i = 0; i < aterms; i++ )
    {
        /* this should be poly_z_zero_poly, but it will be delreffed */
        /* before it is used, so 0 will do                          */
        m_poly_coefft( adashph, i ) = 0;
    }

    respoly = poly_z_zero_poly (pring, apoly);

    for ( j = 0; j < bterms; j++ )
    {
        bexpt = m_poly_expt( bph, j );
        bcoefft = m_poly_coefft( bph, j );

        for ( i = 0; i < aterms; i++ )
        {
            /* remove old term from temporary polynomial */

            m_modpoly_delref( pring, m_poly_coefft( adashph, i ) );

            /* place new coefficient in temporary polynomial */

            m_poly_expt( adashph, i ) = bexpt + m_poly_expt( aph, i );
            m_poly_coefft( adashph, i ) =
		modpoly_mult( pring, mdig, bcoefft, m_poly_coefft( aph, i ) );
        }

        temp = respoly;
        respoly = modpoly_add( pring, mdig, temp, adashpoly );
        m_modpoly_delref( pring, temp );

        /* unfortunate side-effect of modpoly_add( x, adashpoly )  */
        /* is a possible extra reference to adashpoly. Create a    */
        /* new adashpoly (if required).                            */

        if ( m_poly_has_other_refs( adashph ) )
        {
           /* need to create new adashpoly unless no more iterations */

            if ( j != bterms - 1 )
            {
                /* allocate new space for adashpoly */

                m_modpoly_delref (pring, adashpoly);
                m_poly_create_empty( &adashph, m_poly_princvar(aph),
                                        m_poly_least_pvar(aph), aterms );
                adashpoly = m_poly_handle_to_poly( adashph );

                for ( i = 0; i < aterms; i++ )
                {
                    m_poly_coefft( adashph, i ) = 0;
                }
            }
        }
    }

    m_modpoly_delref( pring, adashpoly );

    return respoly;
}



t_poly
modpoly_integer_mult WITH_4_ARGS(
    t_handle,      pring,
    integer_big,   mdig,
    t_poly,     apoly,
    integer_big,   aint
)
/*
** MODPOLY_INTEGER_MULT : modular polynomial modular integer product.
** aint is an element of Zmdig.
** apoly is a polynomial over Zmdig.
** returns : ( aint * apoly ) mod mdig .
*/
{
    t_handle           resph;
    t_handle           aph;
    t_poly        acoefft;
    t_int    termno;
    t_int    nterms;

    if ( m_poly_const( apoly ) )
    {
        return modint_mult( mdig, apoly, aint );
    }

    /* general case: non_trivial polynomial */

    if ( aint == 0 )
        return poly_z_zero_poly (pring, apoly);

    if ( aint == 1 )
        return m_modpoly_incref( pring, apoly );

    aph = m_poly_poly_to_handle( apoly );
    nterms = m_poly_nterms( aph );
    m_poly_create_empty( &resph, m_poly_princvar (aph),
                            m_poly_least_pvar (aph),  m_poly_nterms (aph));

    if (m_poly_univariate (aph))
    {
        for ( termno = 0;termno < nterms; termno++ )
        {
            /* modint multiply term by term */

            m_poly_expt( resph, termno ) = m_poly_expt( aph, termno );
            acoefft = m_poly_coefft( aph, termno );
            m_poly_coefft( resph, termno ) = modint_mult( mdig, acoefft, aint );
        }
    }
    else
    {
        for ( termno = 0;termno < nterms; termno++ )
        {
            /* multiply term by term */

            acoefft = m_poly_coefft( aph, termno );
            m_poly_expt( resph, termno ) = m_poly_expt( aph, termno );
            m_poly_coefft( resph, termno ) 
                  = modpoly_integer_mult( pring, mdig, acoefft, aint );
        }
    }

    return poly_z_clean( pring, m_poly_handle_to_poly( resph ) );
}

