
#include "defs.h"
#include "ring.h"
#include "mat.h"
#include "integer.e"
#include "zm.e"

t_int
mat_zm_trace WITH_2_ARGS(
t_handle,	ring,
matrix,	a
)
/*
 *	Evaluate the trace of a.
 *	a must be a square matrix.
 *
 *	"ring" is the coefficient ring.
 */
{
	block_declarations;
	register t_int	n;
	register t_int	row;
	register integer_big	temp;
	register integer_big	trace;
	register integer_small	diag;
	register integer_big	modulus;
	matrix	mata;

	/*
	 * Calculate the trace of a matrix.
	 * Return the value as a ring element.
	 */
	mata = 0;

	n = mat_row(a);
	if (n != mat_col(a))
		error_internal("Matrix not square in TRACE");

	mat_create_unpkd(ring, a, mata, n, n);

	diag = 1;

	/*
	 * Calculate trace
	 *
	 * Scan the diagonal entries
	 */

	modulus = zm_modulus( ring );
	trace = 0;
	for (row = 1; row <= n; row++)
	{
		temp = trace;
		trace = modint_add(modulus, temp, mat_entry(mata, diag));
		integer_delref( temp );
		diag += n + 1;
	}

	mat_free_unpkd(a, mata);

	return trace;
}
