
#include "defs.h"
#include "ring.h"
#include "mat.h"

t_handle 
mat_ring_is_zero WITH_2_ARGS(
	t_handle,		ring,
	t_ring_elt,	mat
)
/* 
 *	Returns TRUE if mat is zero, coefficients from ring.
 */
{
	integer_small	i;
	integer_small	j;
	t_int		*ptr_mat;
	integer_small	r;
	integer_small	c;
	t_handle		matp;

	c = mat_col( mat );
	r = mat_row( mat );

	matp = 0;
	mat_create_unpkd( ring, mat, matp, r, c );
	ptr_mat = mat_elt0_ptr( matp );

	for ( i=1; i <= r*c; i++ )
	{
		if ( ! ring_is_zero( ring, ptr_mat[ i ] ) )
		{
			mat_free_unpkd( mat, matp );
			return FALSE;
		}
	}

	mat_free_unpkd( mat, matp );

	return TRUE;
}

