
#include "defs.h"
#include "ring.h"
#include "mat.h"

void
mat_ring_compwise_mult_sub WITH_4_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b,
	matrix	*,	result
)
/*
** Result is componentwise multiplication of a by b.
*/
{
	Logical		respack;
	t_int		ma;
	t_int		na;
	t_int		mb;
	t_int		nb;
	matrix		adash;
	matrix		bdash;
	matrix		resultdash;
	t_int		i;
	t_ring_elt	(*ringmult)();

	adash = bdash = resultdash = 0;
	ringmult = ring_multiplication(cring);
	ma = mat_row(a);
	na = mat_col(a);
	mb = mat_row(b);
	nb = mat_col(b);

	if ((ma != mb) || (na != nb))
		error_internal("The matrices have different dimensions in mat_ring_compwise_mult_sub");

	respack = mat_result_pkd(cring, *result);

	mat_alloc_result_unpkd(respack, *result, resultdash, ma, na);
	mat_create_unpkd(cring, a, adash, ma, na);
	mat_create_unpkd(cring, b, bdash, ma, na);

	for (i = 1; i <= ma*na; i++)
	{
		mat_entry(resultdash, i) = (*ringmult)(cring, mat_entry(adash, i), mat_entry(bdash, i));
	}
			
	mat_create_result(cring, respack, *result, resultdash);
	mat_free_unpkd(a, adash);
	mat_free_unpkd(b, bdash);
}


matrix
mat_ring_compwise_mult WITH_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b
)
/*
** Result is componentwise multiplication of a by b.
*/
{
	matrix		result;

	result = 0;
	mat_ring_compwise_mult_sub( cring, a, b, &result );
	return result;
}


