/*
inthdl_shift.c
*/

#include "defs.h"
#include "inthdl.e"
#include "intbig.h"


void
inthdl_shift_right WITH_4_ARGS(
	inthdl_handle,	x,
	inthdl_handle,	y,
	inthdl_length,	digits,
	inthdl_length,	bits
)
/*
Given two multi-precision integer blocks x and y, sets y to the result of
shifting x right by the specified number of digits and bits.
*/
{
    inthdl_length	i, n = digits;
    t_int	k = bits, outk = ZETA - k, outm;
    inthdl_length	len1 = intbig_curr_size(x) - 1;
    t_int	*p = intbig_dig0_ptr(x);
    t_int	*q = intbig_dig0_ptr(y);

    DENY(digits < 0 || bits < 0);

    outm = (1 << k) - 1;
    for (i = 0; n < len1; i++, n++)
	q[i] = (p[n] >> k) | ((p[n + 1] & outm) << outk);

    if (n <= len1 && (q[i] = p[n] >> k))
	i++;

    if ((intbig_curr_size(y) = i) == 0)
	intbig_sign(y) = 0;
    else
	intbig_sign(y) = intbig_sign(x);
}


void
inthdl_shift_left WITH_4_ARGS(
	inthdl_handle,	x,
	inthdl_handle,	y,
	inthdl_length,	digits,
	inthdl_length,	bits
)
/*
Given two multi-precision integer blocks x and y, sets y to the result of
shifting x left by the specified number of digits and bits.
*/
{
    inthdl_length	xlen, n, i, j, top_j;
    unsigned long	botm, high;
    t_int	*p, *q;

    DENY(digits < 0 || bits < 0);

    if ((intbig_sign(y) = intbig_sign(x)) == 0)
	return;

    xlen = intbig_curr_size(x);
    p = intbig_dig0_ptr(x);
    q = intbig_dig0_ptr(y);
    n = digits;
    j = bits;
    top_j = ZETA - j;

    botm = (1 << top_j) - 1;
    intbig_curr_size(y) = xlen + n;
    if (j && (high = p[xlen - 1] >> top_j))
    {
	q[xlen + n] = high;
	intbig_curr_size(y)++;
    }

    for (i = xlen - 1; i >= 1; i--)
	q[i + n] = ((p[i] & botm) << j) | (p[i - 1] >> top_j);

    q[n] = (p[0] & botm) << j;

    for (i = n - 1; i >= 0; i--)
	q[i] = 0;
}
