/*  integer_subtract.c
*/

#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"


integer_big
integer_subtract WITH_2_ARGS(
    integer_big, a,
    integer_big, b
)
/*
Return the difference a minus b
*/
{
    inthdl_sign		old_sign;
    inthdl_handle	bhdl;
    integer_big		diff;

    DEBUG_INTEGER_2("+integer_subtract", a, b);
    if (a == b)
    {
	DEBUG_INTEGER_0("-integer_subtract: a == b");
	return 0;
    }

    if (a == 0)
    {
	DEBUG_INTEGER_0("-integer_subtract: a == 0");
	return integer_negate(b);
    }

    if (integer_is_single(b))
    {
	DEBUG_INTEGER_0("-integer_subtract: b single");
	return integer_add(a, -b);
    }

    /*
    Negate b, add it to a, and restore its sign.  Note that diff cannot turn
    out to be +-b as a is not 0 at this point.
    */

    bhdl = inthdl_big_to_handle(b);
    old_sign = intbig_sign(bhdl);
    intbig_sign(bhdl) = -old_sign;

    diff = integer_add(a, b);

    intbig_sign(bhdl) = old_sign;

    DEBUG_INTEGER_1("-integer_subtract", diff);
    return diff;
}
