#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

integer_big
integer_max     WITH_2_ARGS(
    integer_big,    aint,
    integer_big,    bint
)
/*
 * input: aint, bint -single or infinite-precision integers
 * output:returns maximum (aint, bint)
 */
{
    block_declarations;

    /*
     * case both aint and bint single-precision?
     */

    if ( integer_is_single( aint ) && integer_is_single( bint ) )
	return ( aint > bint ? aint : bint );
    /*
     * case at least one is infinite-precision...
     */

    if (integer_compare(aint, bint) >= 0)
    {
	integer_incref( aint );
	return aint;
    }
    else
    {
	integer_incref( bint );
	return bint;
    }
}

#if 0
t_int int_max(a, b)
t_int     a, b;
{
    return a > b? a: b;
}
#endif
