#include "defs.h"
#include <math.h>
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"
#include "faclst.e"
#include "faclst.h"
#include "dyn_arr.e"
#include "dyn_arr.h"
#include "prime_cert.e"
#include "prime_cert.h"
#include "debug.e"

#define MINEXTN 2

void
integer_lst_factorise WITH_12_ARGS(
    integer_big,         num,
    faclst *,            factorlist,
    dyn_arr_handle *,    remainderhdl,
    integer_small,       basesno,	/* number of bases tried in          */
                                        /* Miller-Rabin                      */
    integer_small,       trialbnd,	/* bound on primes in trial division */
    integer_small,       rhoits,	/* max number iterations for rho     */
    integer_small,       firstat,	/* number of curves in first ecm     */
    integer_small,       firstbnd,	/* smoothness bound first ecm attack */
    integer_small,       maxattack,	/* maximal no of different           */
                                        /* ecm-attacks (0-3)                 */
    integer_small,       smincr,	/* increase sm bnd after every curve */
                                        /* in first attack?                  */
    integer_big,         bound,		/* we are satisfied when factored    */
                                        /* part exceeds this bound           */
    Logical,             proof		/* probable primes need primality    */
                                        /* proof if this flag is true        */
)
/*
** integer_factorise computes the factorisation into primes of a
** general integer.
** Input:  num - positive general integer (single or infinite-precision)
** Output: stack of the prime factors of num plus stack of composite
** factors of num for which factorisation has not been found.
**
** The (first) value returned is a stack containing the prime factors.  The
** stack has two fields per item.  The first item of the stack contains
** the number of different prime divisors (in the first field) and the
** total number of prime divisors (in the 2nd field).  The subsequent
** items contain (unique) prime divisors (in the first field) and the
** number of times the prime occurs (in the 2nd field).  The primes
** are stored in ascending order.  Note that the primes are general
** integers i.e. single or infinite-precision.  The exponents are
** single-precision however.
** If num has not been completely factored, remainders will contain
** the remaining composite factors; remainders is a stack containing
** one field per item, no exponents. If num has been factored 
** completely, remainders is put to 0.
** The factorization is terminated if the complete prime factorization
** has been found, or the product of the prime factors exceeds the bound
** that is specified (e.g. for primality test of num+1), or the steps
** that have been specified have been carried out.
**
** Wieb Bosma, November 1989.
**
** Seriously mutilated by someone else afterwards
*/
{
    block_declarations;

    integer_big	   manycurves = 100000;  /* number of curves in final attempt*/
    integer_big	   largebnd = 1000000;   /* smoothness bound in final attempt*/
    Logical             compo;
    Logical             flag;
    integer_small	attackno;
    integer_big		factor;
    integer_big		cofactor;
    t_int at;
    prime_cert_handle   cert;
    integer_small       fact;
    integer_small       iter;
    integer_small       min;
    faclst              morefact;
    dyn_arr_handle      morerem;
    integer_small	pieceno;
    dyn_arr_handle	pieceshdl;
    dyn_arr_length      len;
    double		pow1;
    double		pow2;
    double		size;
    integer_big		product;
    integer_big         psprime;
    integer_big         quot;
    integer_big         rem;
    integer_big		rest;
    t_int result;
    t_int rtn;
    t_int sign;
    t_int sm;
    t_int str;
    register t_int f;
    register t_int i;
    register t_int j;
    register t_int i1;
    register t_int i2;
    register t_int k;
    register t_int l;
    register t_int m;
    register t_int pr = 0;
    register integer_big temp;
    register integer_big n;

    /* set up debug flag */

    n = integer_incref( num );
    if (v3_df[18])
        cay_print("Factorising %d\n", n);
    *factorlist = faclst_alloc(0);

    /*
     * Reduce to an odd number by removing all 2s
     */
    product = 1;
    while (integer_is_even(n))
    {
        temp = n;
        n = integer_div( temp, 2);
        integer_delref( temp );

        DEBUG_INTEGER_0("found prime factor 2");
        if (v3_df[18])
            cay_print("found prime factor 2\n");
        i_put_prime_in_factors(*factorlist, 2, 1);

        temp = product;		/* transfer */
        product = integer_mult(temp, 2);
        integer_delref(temp);
    }

    if (integer_compare(n, 1) == 0)
    {
        /*
         * We are finished already
         */
        *remainderhdl = 0;
        return;
    }

    /*
     * All composite parts still to be factored will be put in pieces.
     */
    
    pieceshdl = dyn_arr_alloc(1);
    pieceno = 2;    /* to make sure the right thing happens in EXIT  ... */
    /*
     * Find small prime divisors of n by trial division up to trialbnd
     */
    min = 3;
    DEBUG_INTEGER(("start trial division up to : ", 1, trialbnd));
    if (v3_df[18]) cay_print("start trial division up to %d\n", trialbnd);
    
    for (;;)
    {
        i_trial_div_factor(n, min, trialbnd, &fact, &rest);
        /*
        ** fact will be a small integer, as trialbnd is small
        */

        if (fact <= 1)
            break;

        DEBUG_INTEGER(("found prime factor : ", 1, fact));
        if (v3_df[18]) cay_print("found prime factor %d\n", fact);
         min = fact;

        temp = product;
        product = integer_mult( temp, fact);	/* product *= fact */
        integer_delref(temp);

        i_put_prime_in_factors(*factorlist, fact, 1);

/* DON'T UNDERSTAND THE FOLLOWING LINES - JEROME*/
        if (integer_compare(rest, 1) == 0)
        {
            /* this is only true if i_trial_div_factor */
            /* found n as a prime divisor of n         */
            integer_delref( n );
            dyn_arr_element( pieceshdl, 0) = 1; /* rest == 1 */
            dyn_arr_curr_length( pieceshdl ) = 1;
            goto EXIT;
        }
        integer_delref(n);
        n = rest;   /* transfer */
    }
    if (v3_df[18])
        cay_print("Remainder after trial division: %d\n", n);

    /* used to be rest = n and left an unrefferenced block. */
    /* n and rest are the same since fact == 1.             */
    integer_delref (n);

    /*
     * Check whether rest is prime, using Miller-Rabin for basesno bases.
     * If it is (probably) prime, we are finished.
     */
    if(i_miller_rabin(rest, basesno) == 1)
    {
        i_put_prime_in_factors( *factorlist, rest, 1);
        integer_delref( rest );
        goto EXIT;
    }

    DEBUG_INTEGER_2("proven composite, using at most number of miller-bases: "
        , 1, basesno);
     if (v3_df[18])
        cay_print("proven composite, using at most %d miller-bases\n", basesno);
    dyn_arr_element( pieceshdl, 0) = rest;		/* transfer */
    dyn_arr_curr_length( pieceshdl) = 1;

    if(integer_compare(product, bound) >= 0 )
    {
        /* we found enough factors */
        pieceno = 1;
        goto EXIT;
    }

    /*
     * More left to factor, in rest ... apply pollard-rho, using at most
     * rhoits iterations
     */
    pieceno = 1;

    /* Johannes' fix */


/*
 *  First we check whether the rest is a square
 *  (JS 6/7/92)
 */


     integer_sqrt(n, &rtn, &sign);
     if(sign == 0)
     {
         if (v3_df[18]) cay_print("Number was perfect square\n");
         if(i_miller_rabin(rtn, basesno) == 1 )
         {
            temp = integer_mult(product, rtn);
            integer_delref(product);
            product = integer_mult(temp, rtn);
            integer_delref(temp);
            i_put_prime_in_factors(*factorlist, rtn, 2);
            if (v3_df[18])
            cay_print("found prime %d, with multiplicity 2\n", rtn);
            integer_delref(rtn);
            pieceno++;
            if(integer_compare(product, bound) >= 0 )
            {
                /* we found enough factors */
                goto EXIT;
            }
         }
         else
         {
            dyn_arr_element(pieceshdl, pieceno - 1) = rtn;
            len = dyn_arr_curr_length(pieceshdl);
            dyn_arr_assure_space(pieceshdl, len + 1, MINEXTN);
            dyn_arr_element(pieceshdl, len) = integer_incref(rtn);
            dyn_arr_curr_length(pieceshdl) = len + 1;
         }
   }
   else
        integer_delref(rtn);



    /* End Johannes' fix */

    DEBUG_INTEGER_0("enter pollard rho");
    if (v3_df[18]) cay_print("enter pollard rho \n");
    iter = rhoits;
    while(iter>0 && pieceno <= dyn_arr_curr_length( pieceshdl))
    {
        DEBUG_INTEGER_2("iterations = ", 1, iter);
        if (v3_df[18]) cay_print("iterations = %d\n", iter);
        compo = FALSE;

        m = dyn_arr_element( pieceshdl, pieceno-1 );    /* transfer */
        dyn_arr_element( pieceshdl, pieceno-1 ) = 0;

        if (integer_sign( m ) == 0)
        {
            /*
            ** found a "blank" spot that has already been done and zeroed
            */
            pieceno++;
            continue;
        }

        i_pollard_rho_factor( m, 1, 1, &iter, &fact, &rest );
        integer_delref( m );

        if(integer_compare(fact, 1)==1 )
        {
            if(i_miller_rabin(fact,basesno) == -1)
            {
                /* factor found is composite */
                dyn_arr_element( pieceshdl, pieceno-1 ) = fact; /* transfer */
                compo = TRUE;
            }
            else
            {
                /* factor found is prime: find multiplicity */
                for( k=0; ; )
                {
                    temp = product;
                    product = integer_mult( temp, fact);
                    integer_delref( temp );
                    ++k;

                    integer_quot_rem(rest, fact, &quot, &rem);
                    /*
                    ** rem is a small integer as fact is small
                    */
                    if (rem != 0)
                        break;

                    integer_delref(rest);
                    rest = quot;   /* transfer */
                }

                i_put_prime_in_factors( *factorlist, fact, k );
                integer_delref( fact );
            }

            if(integer_compare(rest, 1) == 0) 
            {
                /* cofactor=1, go on with next piece */
                if(!compo)
                    pieceno++;
                /* fake integer_delref( rest ), rest == 1 */
            }
            else if (i_miller_rabin( rest, basesno) == 1)
            {
                /* cofactor is prime, proceed to next piece */

                temp = product;
                product = integer_mult( temp, rest );
                integer_delref( temp );

                i_put_prime_in_factors( *factorlist, rest, 1);
                DEBUG_INTEGER_2("found prime, multiplicity : ", rest, 1);
                if (v3_df[18])
                    cay_print("found prime %d, multiplicity %d\n", rest, 1);

                integer_delref( rest );

                if(!compo)
                    pieceno++;
            }
            else
            {
                /*
                 * cofactor is composite, put it at the end of
                 * the stack of pieces if factor was also composite
                 */
                if(compo == TRUE)
                {
                    len = dyn_arr_curr_length( pieceshdl );
                    dyn_arr_assure_space( pieceshdl, len+1, MINEXTN);
                    dyn_arr_element( pieceshdl, len ) = rest;	/* transfer */
                    dyn_arr_curr_length( pieceshdl ) = len+1;
                }
                else
                {
                        dyn_arr_element( pieceshdl, pieceno-1 ) = rest;
                                        /* transfer */
                }
            }
        }
        else
        {
            /*
            ** Failed to find a factor - put rest in pieces
            ** fake integer_delref( fact ), fact == 1
            */
            dyn_arr_element( pieceshdl, pieceno-1 ) = rest;	/* transfer */
        }

        if(integer_compare(product, bound) >= 0 )
        {
            /* we found enough factors */
            goto EXIT;
        }
    }
    /*
     * Have we found all factors yet?
     */
    if(pieceno > dyn_arr_curr_length( pieceshdl ))
    {
        goto EXIT;
    }

#ifndef KANT

    DEBUG_INTEGER_0("enter ecm \n");
    if (v3_df[18]) cay_print("enter ecm \n");

    /*
     * Still more to factor in rest ... apply the Elliptic Curve Method!
     * The first attack tries with small smoothness bound and small 
     * number of curves; if that fails: the hard way, choosing the optimal
     * parameters for a number of the current size that is the product of
     * two primes of about equal size. First check that number is not
     * a square ... !
     * If this also fails, which is unlikely, we keep on trying with
     * large smoothness bound and lots of curves.
     * This may take a while ...
     */

    m = 1;
    attackno = 1;
    while(pieceno <= dyn_arr_curr_length(pieceshdl) && attackno <= maxattack )
    {
        compo = FALSE;
        /* NEXT INCREF PUT IN WB */
        n = integer_incref(dyn_arr_element( pieceshdl, pieceno-1 ));
        if(attackno == 1)
        {
            cofactor = 1;
            if(smincr == 0) smincr = 100;
            while(cofactor == 1 && m <= firstat)
            {
                if (v3_df[18])
                    cay_print("first attack - start ecm (m = %d)\n", m);
                ecm_new_main(1, firstbnd+(m-1)*smincr, m+1, n, &factor, &cofactor, pr);
                m++;
            }
        }
        else if(attackno == 2)
        {
            if(v3_df[18]) cay_print("Second attack necessary\n");
            integer_sqrt(n, &rtn, &sign);
            if(sign == 0)
            {
                if (v3_df[18]) cay_print("Number was perfect square\n");
                if(i_miller_rabin(rtn, basesno) == 1 )
                {
                    temp = integer_mult(product, rtn);
                    integer_delref(product);
                    product = integer_mult(temp, rtn);
                    integer_delref(temp);
                    i_put_prime_in_factors(*factorlist, rtn, 2);
                    if (v3_df[18])
                        cay_print("found prime %d, with multiplicity 2\n", rtn);
                    integer_delref(rtn);
                    pieceno++;
                    if(integer_compare(product, bound) >= 0 )
                    {
                        /* we found enough factors */
                        goto EXIT;
                    }
                }
                else
                {
                    dyn_arr_element(pieceshdl, pieceno - 1) = rtn;
                    len = dyn_arr_curr_length(pieceshdl);
                    dyn_arr_assure_space(pieceshdl, len + 1, MINEXTN);
                    dyn_arr_element(pieceshdl, len) = integer_incref(rtn);
                    dyn_arr_curr_length(pieceshdl) = len + 1;
                    /*
                     * This is stupid, since we will now
                     * factor the square root twice!
                     * But it will not happen, and if it
                     * does, the square root will be
                     * easy to factor
                     */
                }
                continue;	/* Go to next piece */
            }
            else
                integer_delref(rtn);
            /* this check should be unnecessary - n should never be single */
            if (integer_is_single(n))
            {
                size = 0.5 * log(536870912.0) / log(10.0);
            }
            else
            {
                size = ((double)intbig_curr_size(inthdl_handle_to_big(n)) - 0.5)
                            * log(536870912.0) / log(10.0);
            }
            pow2 = (t_double) size / 20.0; 
            pow1 = (t_double) size /( 2 * (2.95 + 0.8 * pow2));
            sm =  (t_int) pow(10.0, pow1);
            at =  2 * (t_int) pow(10.0, pow2); 
            if(v3_df[18])
                cay_print("Use smoothness bound %d with %d curves\n", sm, at);
            ecm_new_main(at, sm, m+1, n, &factor, &cofactor, pr);
        }
        else if(attackno == 3)
        {
            if(v3_df[18]) cay_print("Third attack \n");
            ecm_new_main(manycurves, largebnd, m+1, n, &factor, &cofactor, pr);
        }
        if (cofactor == 1)	/* attempts failed */
        {
            fact = 1;
            if(attackno == 3)
            {
                if(v3_df[18]) cay_print("WE COULD NOT DO IT\n");
                goto EXIT;
            }
            else attackno += 1;
        }
        else if (factor == 1)
        {
            /* Trivial factor */
                /* number is prime after all */
                if(v3_df[18]) cay_print("prime factor %d found\n", n);
                temp = product;
                product = integer_mult(product, n);
                integer_delref(temp);
                i_put_prime_in_factors(*factorlist, n, 1);
                integer_delref(n);
                pieceno++;
        }
        else
        {
            t_handle	context;

            /* Found a factor */
            integer_delref(n);
            fact = factor;
            rest = cofactor;
            if(i_miller_rabin(fact,basesno) == -1)
            {
                dyn_arr_element(pieceshdl, pieceno - 1) = fact;
                if (v3_df[18]) cay_print("found composite factor %d\n", fact);
                compo = TRUE;
            }
            else
            {
                Logical	first;

                k =0;
                rem = 0;
                first = TRUE;
                while(integer_sign(rem) == 0)
                {
                    if (!first)
                    {
                        integer_delref(rest);
                        rest = quot;
                    }
                    else
                        first = FALSE;
                    k++;
                    temp = product;
                    product = integer_mult(product, fact);
                    integer_delref(temp);
                    integer_quot_rem(rest, fact, &quot, &rem);
                }
                integer_delref(rem);
                integer_delref(quot);
                i_put_prime_in_factors(*factorlist, fact, k);
                if (v3_df[18])
                    cay_print("found prime %d with multiplicity %d\n", fact, k);
                integer_delref(fact);
            }
            if(integer_compare(rest, 1) == 0) 
            {
                /* cofactor=1, go on with next piece */
                if(!compo)
                    pieceno++;
            }
            else if (i_miller_rabin(rest, basesno) == 1)
            {
                temp = product;
                product = integer_mult(product, rest);
                integer_delref(temp);
                i_put_prime_in_factors(*factorlist, rest, 1);
                if (v3_df[18]) cay_print("found prime factor %d\n", rest);
                integer_delref(rest);
                rest = 1;
                if(!compo) pieceno++;
            }
            else
            {
                if(compo)
                {
                    len = dyn_arr_curr_length(pieceshdl);
                    dyn_arr_assure_space(pieceshdl, len + 1, MINEXTN);
                    dyn_arr_element(pieceshdl, len) = rest;
                    dyn_arr_curr_length(pieceshdl) = len + 1;
                    if (v3_df[18])
                        cay_print("found two composite factors %d and %d, we proceed\n", fact, rest);
                }
                else
                    dyn_arr_element(pieceshdl, pieceno - 1) = rest;
            }
        }
        if(integer_compare(product, bound) >= 0 )
        {
            /* we found enough factors */
            goto EXIT;
        }
    }
#endif /* KANT */

EXIT:   ;
    integer_delref(product);

    if(proof)
    {
        /*
        ** we need to prove that all probable primes are prime
        */

        cert = prime_cert_alloc( 1 );  /* no certificate */
LOOP:	;
        f = faclst_num_prime( *factorlist );
        for( i=0; i<f; i++ )
        {
            psprime = faclst_prime( *factorlist, i );	/* alias */

            if (integer_sign( psprime ) == 0 )
                /*
                ** found a blank spot in the array that has already been done
                */
                continue;

            if(!integer_is_prime( psprime, cert, FALSE, 1000 ))
            {
                /*
                ** found a pseudoprime, incref the alias
                */
                integer_incref( psprime );

                k = faclst_expon( *factorlist, i);
                i_put_prime_in_factors( *factorlist, psprime, -k );

                flag = FALSE;
                integer_lst_factorise(psprime, &morefact, &morerem, 25, 998,
                    1023, 10, 500, 3, 100, psprime, flag);

                for( j=0; j < faclst_num_prime( morefact ); j++)
                {
                    i_put_prime_in_factors( *factorlist,
                        faclst_prime(morefact, j), faclst_expon(morefact, j));
                }

                integer_delref( psprime );

                faclst_delete( &morefact );
                dyn_int_arr_delete( &morerem );
                /*
                ** should the above line be so ? The remainders at this stage
                ** should be added to the remainders returned from the function
                ** ( IMHO )
                */
                goto LOOP;
            }

            /*
            ** certificate might have been changed in is_prime
            */
            prime_cert_clean( cert );
        }

        prime_cert_delete( &cert );
    }

    if (pieceno <= dyn_arr_curr_length( pieceshdl ))
    {
        m = dyn_arr_curr_length( pieceshdl ) - pieceno + 1;
        *remainderhdl = dyn_arr_alloc( m );
        for ( j=0; j<m; ++j )
            dyn_arr_element( *remainderhdl, j )
                = integer_incref( dyn_arr_element( pieceshdl, j + pieceno - 1 ) );
        dyn_arr_curr_length( *remainderhdl ) = m;
    }
    else
        *remainderhdl = 0;

    dyn_int_arr_delete( &pieceshdl );
    return;
}


#ifndef KANT
void
integer_stk_factorise WITH_12_ARGS(
    integer_big,         num,
    t_int *,               factors,
    t_int *,               remainders,
    integer_small,       basesno,	/* number of bases tried in          */
                                        /* Miller-Rabin                      */
    integer_small,       trialbnd,	/* bound on primes in trial division */
    integer_small,       rhoits,	/* max number iterations for rho     */
    integer_small,       firstat,	/* number of curves in first ecm     */
    integer_small,       firstbnd,	/* smoothness bound first ecm attack */
    integer_small,       maxattack,	/* maximal no of different           */
                                        /* ecm-attacks (0-3)                 */
    integer_small,       smincr,	/* increase sm bnd after every curve */
                                        /* in first attack?                  */
    integer_big,         bound,		/* we are satisfied when factored    */
                                        /* part exceeds this bound           */
    Logical,             proof		/* probable primes need primality    */
                                        /* proof if this flag is true        */
)
/*
** integer_factorise computes the factorisation into primes of a
** general integer.
** Input:  num - positive general integer (single or infinite-precision)
** Output: stack of the prime factors of num plus stack of composite
** factors of num for which factorisation has not been found.
**
** The (first) value returned is a stack containing the prime factors.  The
** stack has two fields per item.  The first item of the stack contains
** the number of different prime divisors (in the first field) and the
** total number of prime divisors (in the 2nd field).  The subsequent
** items contain (unique) prime divisors (in the first field) and the
** number of times the prime occurs (in the 2nd field).  The primes
** are stored in ascending order.  Note that the primes are general
** integers i.e. single or infinite-precision.  The exponents are
** single-precision however.
** If num has not been completely factored, remainders will contain
** the remaining composite factors; remainders is a stack containing
** one field per item, no exponents. If num has been factored 
** completely, remainders is put to 0.
** The factorization is terminated if the complete prime factorization
** has been found, or the product of the prime factors exceeds the bound
** that is specified (e.g. for primality test of num+1), or the steps
** that have been specified have been carried out.
**
** Wieb Bosma, November 1989.
*/
{
    block_declarations;

    dyn_arr_handle    remhdl;
    faclst            factorlist;
    integer_big       temp;
    integer_small     i;
    integer_small     len;
    integer_small     numprime;

    integer_lst_factorise( num, &factorlist, &remhdl, basesno, trialbnd,
        rhoits, firstat, firstbnd, maxattack, smincr, bound, proof );

    /*
    ** convert factorlist (lst) form to factorstack (stk) form
    */

    numprime = faclst_num_prime( factorlist );
    *factors = sh_newstk( numprime+1, 2, 0, 1, 1 );
    sfld( *factors, 1, 1, numprime );
    sfld( *factors, 1, 2, faclst_num_expon( factorlist ) );

    for ( i=0; i<numprime; ++i )
    {
        temp = faclst_prime( factorlist, i );
        sfld( *factors, i+2, 1, temp );		/* transfer */
        sfld( *factors, i+2, 2, faclst_expon( factorlist, i ) );
    }

    /*
    ** all primes are transferred out, no need for faclst_delete()
    */
    mem_delete_hptr( &factorlist );

    /*
    ** convert remainder dynamic array to stack
    */

    if (remhdl == 0)
    {
        *remainders = 0;
    }
    else
    {
        len = dyn_arr_curr_length( remhdl );
        *remainders = sh_newstk( len, 0, 0, 1, 1 );

        for ( i=0; i<len; ++i )
        {
            temp = dyn_arr_element( remhdl, i );
            sfld( *remainders, i+1, 1, integer_incref( temp ) );
        }

        dyn_int_arr_delete( &remhdl );
    }
}

t_handle
integer_factorise_simple WITH_1_ARG(
        integer_big,	n
)
/*
Do a default factorisation and throw away the remainders
*/
{
        t_handle	factors;
        t_handle	remainders;

        integer_stk_factorise(n, &factors, &remainders, 10, 1000, 1023, 10, 500, 3, 100, n, TRUE);
        if (remainders)
                sh_delete(&remainders);
        return factors;
}

#endif /* KANT */
