#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

void
ib_sqrt WITH_3_ARGS(
    int,     adig,
    int *,   sqrt,
    int *,   sign
)
/*
** Input:  adig - non-negative beta-digit
** Output: sqrt - square root of adig, a beta-digit
**     sign - sign of adig - sqrt ** 2
** ib_sqrt computes digit square root.
** sqrt(adig) = FLOOR(\/ adig)
*/
{
    register int    quot;
    register int    temp;

    /*
     * Case adig = 0
     */

    if (adig == 0)
    {
	*sqrt = 0;
	*sign = 0;
	return;
    }

    /*
     * case adig > 0...
     * compute first approximation
     */
    temp = ib_log2(adig);
    temp = (temp + 1) / 2;
    *sqrt = 1 << ((temp + 1) - 1);
    /*
     * start of loop to compute square-root via modified newton method
     */
    for (;;)
    {
	quot = adig / *sqrt;
	if (*sqrt <= quot)
	{
	    temp = (adig - *sqrt * *sqrt);
	    *sign = (temp != 0);		/* temp >= 0 */
	    return;
	}
	*sqrt = (*sqrt + quot) / 2;
    }
}
