#include "defs.h"
#include "mp.e"
#include "comp.e"
#include "conv.e"

t_comp
comp_power WITH_3_ARGS(
	t_handle,		r,
	t_comp,		a,
	t_int,	n
)
/*
** Returns a ^ n.
*/
{
	t_comp		b;
	mp_float	are, aim, bre, bim;
	mp_float	temp1, temp2, temp3, temp4, temp5;

	switch (n)
	{
	case -1:	return (comp_inverse (r, a));
	case  1:	return (comp_incref (a));
	case  2:	return (comp_mult (r, a, a));
	default:	;
	}

	temp1 = mp_alloc( real_base, comp_beta_prec( r ));
	temp2 = mp_alloc( real_base, comp_beta_prec( r ));
	temp3 = mp_alloc( real_base, comp_beta_prec( r ));
	temp4 = mp_alloc( real_base, comp_beta_prec( r ));
	temp5 = mp_alloc( real_base, comp_beta_prec( r ));

	comp_split_mp( a, are, aim );

	b = comp_alloc( real_base, comp_beta_prec( r ));
	comp_split_mp( b, bre, bim );

	mp_atan2( aim, are, temp1 );
	if ( integer_is_single( n ) )
	{
		mp_mul_int( temp1, n, temp2 );
	}
	else
	{
		conv_int_to_mp( n, temp3 );
		mp_mul( temp1, temp3, temp2 );
	}
	mp_mul( are, are, temp1 );
	mp_mul( aim, aim, temp3 );
	mp_add( temp1, temp3, temp4 );
	if (( n % 2 ) == 0 )
	{
		mp_int_power( temp4, n/2, temp1 );
	}
	else
	{
		mp_sqrt( temp4, temp3 );
		mp_int_power( temp3, n, temp1 );
	}
	mp_priv_cis( temp2, temp3, temp4, TRUE, TRUE );
	mp_mul( temp1, temp3, bre );
	mp_mul( temp1, temp4, bim );

	mp_delete_float( temp1 );
	mp_delete_float( temp2 );
	mp_delete_float( temp3 );
	mp_delete_float( temp4 );
	mp_delete_float( temp5 );

	return b;
}

