
#include "defs.h"
#include "mp.e"
#include "comp.e"

t_comp
comp_inverse WITH_2_ARGS(
	t_handle,		r,
	t_comp,		a
)
/*
** Returns 1 / a.
*/
{
	t_comp		b;
	mp_float	are, aim, bre, bim;
	mp_float	temp1, temp2, temp3;

	temp1 = mp_alloc( real_base, comp_beta_prec( r ));
	temp2 = mp_alloc( real_base, comp_beta_prec( r ));
	temp3 = mp_alloc( real_base, comp_beta_prec( r ));

	comp_split_mp( a, are, aim );

	b = comp_alloc( real_base, comp_beta_prec( r ));
	comp_split_mp( b, bre, bim );

	mp_mul( are, are, temp1 );
	mp_mul( aim, aim, temp2 );
	mp_add( temp1, temp2, temp3 );
	mp_div( are, temp3, bre );
	mp_neg( aim, temp1 );
	mp_div( temp1, temp3, bim );

	mp_delete_float( temp1 );
	mp_delete_float( temp2 );
	mp_delete_float( temp3 );

	return b;
}

