#include "defs.h"
#include "mp.e"
#include "comp.e"

public t_handle
glue_comp_mult( ring, a, it1, b, it2, res_e, res_it )
t_handle ring, a, it1, b, it2, *res_e, *res_it;
{
	*res_e =comp_mult(ring,a,b);
	return NH;
}

public
t_handle glue_comp_eq (s1, e1, it1, s2, e2, it2)
t_handle s1, e1, s2, e2;
t_int it1, it2;
{
	return comp_eq(s1, e1, e2);
}

public
t_handle glue_comp_add(s1, e1, e2, res_e)
t_handle s1, e1, e2, *res_e;
{
	*res_e  = comp_add(s1, e1, e2);
	return NH;
}

public t_handle
glue_comp_modulus(s1, e1, res_s, res_e)
t_handle s1, e1, *res_s, *res_e;
{
	*res_e = comp_modulus(s1, e1);
	*res_s = m_real_str_incref( comp_real_field( s1 ) );
	return NH;
}

public t_handle
glue_comp_subtract(s1, e1, e2, res_e)
t_handle s1, e1, e2, *res_e;
{
	*res_e = comp_subtract(s1,e1,e2);
	return NH;
}

public t_handle
glue_comp_negate(s, e, res_e)
t_handle s, e, *res_e;
{
	*res_e = comp_negate(s,e);
	return NH;
}

public t_handle
glue_comp_power( s1, e1, it1, n, res_s, res_e, res_it )
t_handle s1, e1, it1, n, *res_s, *res_e, *res_it;
{
	*res_e = comp_power( s1, e1, n );
	*res_s = m_comp_str_incref( s1 );
	return NH;
}

public t_handle
glue_comp_slash( s1, e1, e2 )
t_handle s1, e1, e2;
{
	return comp_divide( s1, e1, e2 );
}

public t_handle
glue_comp_conjugate( s1, e1)
t_handle s1, e1;
{
	return comp_conjugate( s1, e1 );
}

public t_handle
glue_comp_is_one( s, e )
t_handle s, e;
{
	mp_float	re, im;

	comp_split_mp(e, re, im);
	return mp_cmp_int(re, 1) == 0 && mp_cmp_int(im, 0) == 0;
}

public t_handle
glue_comp_is_minus_one( s, e )
t_handle s, e;
{
	mp_float	re, im;

	comp_split_mp(e, re, im);
	return mp_cmp_int(re, -1) == 0 && mp_cmp_int(im, 0) == 0;
}

public t_handle
glue_comp_is_zero( s, e )
t_handle s, e;
{
	mp_float	re, im;

	comp_split_mp(e, re, im);
	return mp_cmp_int(re, 0) == 0 && mp_cmp_int(im, 0) == 0;
}

public t_handle
glue_comp_argument( s, e, res_s, res_e )
t_handle s, e, *res_s, *res_e;
{
	*res_e = comp_arg( s, e );
	*res_s = m_real_str_incref( comp_real_field( s ) );
	return NH;
}

public t_handle
glue_comp_norm( s1, e1, res_s, res_e )
t_handle s1, e1, *res_e, *res_s;
{
	*res_e = comp_norm( s1, e1 );
	*res_s = m_real_str_incref(comp_real_field(s1));
	return NH;
}

public t_handle
glue_comp_comp(e1, nr, ni)
t_handle e1, nr, ni;
{
	return comp_make( e1, nr, ni );
}

public t_handle
glue_comp_complex_field(prec)
t_handle prec;
{
	return comp_create_hard( prec );
}

public t_handle
glue_comp_precision(s, e)
t_handle s, e;
{
	return comp_precision( s, e );
}

public t_handle
glue_comp_inverse(str, elt, it, res_elt, res_it)
t_handle str, elt, it, *res_elt, *res_it;
{
    *res_elt = comp_inverse(str, elt);
    *res_it = 0;
	return NH;
}
