#ifndef KANT

#include "defs.h"
#include "ring.e"
#include "comp.e"
#include "bind.h"
#include "conv.e"
#include "eseq.e"

t_logical
comp_elt_coerce WITH_7_ARGS(
	t_handle,	cring,
	t_handle,	str,
	t_handle,	elt,
	t_int,		itm,
	t_handle *,	nelt,
	t_int *,	nitm,
	t_logical,	do_error
)
{
	ASSERT (structure_repnum(cring) == REP_COMP);

	switch (structure_varnum(str))
	{
	case VAR_RING:
		switch (ring_type (str))
		{
		case RING_Z:
			*nelt = conv_int_to_comp( cring, elt );
			break;
	 
		case RING_Q:
			*nelt = conv_q_to_comp( cring, elt );
			break;
	 
		case RING_QM:
			*nelt = conv_qm_to_comp( cring, str, elt );
			break;
	
		case RING_QUAD:
			*nelt = conv_quad_to_comp( cring, str, elt );
			break;
	 
		case RING_R:
			if (real_beta_prec(str) > comp_beta_prec(cring))
				return FALSE;
			*nelt = conv_real_to_comp( cring, elt );
			break;
	 
		case RING_C:
			*nelt = conv_comp_to_comp( elt, cring );
			break;
	 
		default:
			/*
			** complex and incompatible case.
			*/
			return FALSE;
		}
		break;
	case VAR_POW_SEQ: /* sequence of 2 reals */
		if (eseq_length( elt) != 2)
			return FALSE;

		if (structure_varnum(eseq_univ_str( elt)) != VAR_RING)
			return FALSE;

		if ((ring_type(eseq_univ_str( elt)) == RING_R) &&
		(real_beta_prec(eseq_univ_str( elt)) > comp_beta_prec(cring)))
			return FALSE;

		*nelt = conv_seq_to_comp(cring,  elt);
		break;
	default:
		return FALSE;
	}
	*nitm = EVAL_NO_ITEM;
	return TRUE;
}
		
#else /* KANT */

#include "defs.h"
#include "ring.e"
#include "comp.e"
#include "conv.e"

t_logical
comp_elt_coerce WITH_7_ARGS(
	t_handle,	cring,
	t_handle,	str,
	t_handle,	elt,
	t_int,		itm,
	t_handle *,	nelt,
	t_int *,	nitm,
	t_logical,	do_error
)
{
	ASSERT (structure_repnum(cring) == REP_COMP);

	switch (ring_type (str))
	{
	case RING_Z:
		*nelt = conv_int_to_comp( cring, elt );
		break;
 
	case RING_Q:
		*nelt = conv_q_to_comp( cring, elt );
		break;
 
	case RING_R:
		if (real_beta_prec(str) > comp_beta_prec(cring))
			return FALSE;
		*nelt = conv_real_to_comp( cring, elt );
		break;
 
	case RING_C:
		*nelt = conv_comp_to_comp( elt, cring );
		break;
 
	default:
		/*
		** complex and incompatible case.
		*/
		return FALSE;
	}
	*nitm = 0;
	return TRUE;
}
		
#endif /* KANT */
