#include "defs.h"
#include "block.e"

t_void block_init(h, t)
t_handle	h;
t_uint		t;
{
    ASSERT(t < (1 << BLOCK_TYPE_BITS));
    *block_access(h) = 1 | (t << BLOCK_SHIFT);
}

t_handle block_incref(h)
t_handle h;
/*
Increments the reference count for h and returns h.
*/
{
    t_block_p	p;

    p = block_access(h);
    ASSERT(((*p) & BLOCK_MASK) > 0);
    (*p)++;

    return h;
}

t_logical block_decref_delete(h)
t_handle h;
/*
Decrements the reference count for h and deletes h if the count goes to 0.
Returns whether the h is deleted.
*/
{
    t_block_p	p;
    t_uint	count;

    p = block_access(h);
    ASSERT(((*p) & BLOCK_MASK) > 0);

    count = (--(*p)) & BLOCK_MASK;
    if (count == 0)
    {
	mem_delete_h(h);
	return TRUE;
    }

    return FALSE;
}

t_handle block_copy(h, n)
t_handle h;
t_uint n;
/*
Creates a new copy of the block with handle h and assigns its refcount to be n.
*/
{
    t_handle	res;
    t_block_p	p;

    res = mem_copy(h);
    p = block_access(res);
    ASSERT(n < (1 << BLOCK_REFCOUNT_BITS));
    *p = n | (*p & ~BLOCK_MASK);

    return res;
}
