#include "mem.h"

t_void mem_show_stats()
{
    static t_len	last_discrepancy;
    t_len		discrepancy;

    discrepancy = memi_stats_alloc + memi_stats_alloc_words - memi_stats_delete;

    printf("total memory:   %9d bytes\n", PTRS_TO_BYTES(memi_high_mem - memi_base_mem));
    printf("total allocs:     %7d\n", memi_stats_alloc + memi_stats_alloc_words);
    printf("total deletes:    %7d\n", memi_stats_delete);
    printf("discrepancy:      %7d\n", discrepancy);
    printf("accesses:      %10d\n", memi_stats_access);
    printf("get_block:        %7d\n", memi_stats_get_block);
    printf("small get_blocks: %7d\n", memi_stats_small_get_block);
    printf("small hit rate:   %7.2g%%\n",
	    100.0 * (double)memi_stats_small_get_block / (double)memi_stats_get_block
    );
    printf("byte allocs:      %7d\n", memi_stats_alloc);
    printf("word allocs:      %7d\n", memi_stats_alloc_words);
    printf("total extends:    %7d\n", memi_stats_extend);
    printf("total reduces:    %7d\n", memi_stats_reduce);
    printf("reduce extra:     %7d\n", memi_stats_reduce_spare);
    printf("total mallocs:    %7d\n", memi_stats_malloc);
    printf("total frees:      %7d\n", memi_stats_free);
    printf("total reallocs:   %7d\n", memi_stats_realloc);
    printf("memory limit:   %9d bytes\n", mem_size_limit);
    printf("extension size: %9d bytes\n", mem_extension_size);
    printf("meta discrepancy: %7d\n", discrepancy - last_discrepancy);

    last_discrepancy = discrepancy;
}

t_void mem_reset_stats()
{
    memi_stats_get_block = memi_stats_small_get_block =
    memi_stats_reduce = memi_stats_alloc = memi_stats_reduce_spare =
    memi_stats_extend = memi_stats_delete = memi_stats_malloc =
    memi_stats_free = memi_stats_coal = memi_stats_alloc_words =
    memi_stats_reduce_words = memi_stats_alloc_words_zero =
    memi_stats_reduce_words_spare = memi_stats_realloc = 0;
}
