#include "mem.h"

t_void mem_show_free()
/*
Show all free lists.
*/
{
    t_ptr	bp, lp;

    for (lp = (t_ptr)memi_free_lists; lp < memi_free_limit; lp++)
    {
	t_int	c;

	bp = DEREF(lp);
	if (bp)
	{
	    c = lp - (t_ptr)memi_free_lists;
	    mem_printf("%d:", c);

	    while (bp)
	    {
		mem_printf(
		    " %d", (NEXT_BLOCK(bp) - bp - HEADER_SIZE) * sizeof(t_ptr)
		);
		bp = NEXT_FREE(bp);
	    }
	    mem_puts("");
	}
    }
}

t_void memi_show_blocks(active)
t_int active;
{
    t_ptr	bp, next, next_free;
    double	pow();

    mem_puts("Address      Size      Type Handle/NF   Where/Previous Free");

    for (bp = memi_base_mem; bp < memi_high_mem; bp = next)
    {
	next = NEXT_BLOCK(bp);
	next_free = NEXT_FREE(bp);

	IF_USE_MARKS(
	    if (BLOCK_MARK(bp) < memi_mark)
		continue;
	)

	if (active && IS_FREE(next_free))
	    continue;

	mem_printf(
	    "%7x  %8d     ", bp, (next - bp - HEADER_SIZE) * sizeof(t_ptr)
	);

	if (next_free == P_MALLOC)
	    mem_printf("Malloc");
	else if (next_free == P_MEM_MALLOC)
	{
	    mem_printf("Mem Malloc    ");
	    IF_TRACE_ALLOCS(
		mem_printf("    %s %d",
		    mem_strip_head(BLOCK_FILE_NAME(bp)), BLOCK_LINE_NUM(bp)
		);
	    )
	}
	else if (next_free == P_BIFFABLE_MALLOC)
	{
	    mem_printf("Biffable Malloc    ");
	    IF_TRACE_ALLOCS(
		mem_printf("    %s %d",
		    mem_strip_head(BLOCK_FILE_NAME(bp)), BLOCK_LINE_NUM(bp)
		);
	    )
	}
	else if (next_free == P_HANDLE_TABLE)
	    mem_printf("Handle Table");
	else if (next_free == P_SBRK_GAP)
	    mem_printf("Data Gap");
	else if (IS_ACTIVE(next_free))
	{
	    mem_printf("Active %7d", HNORM(next_free - HANDLE_BASE));
	    IF_TRACE_ALLOCS(
		mem_printf("    %s %d",
		    mem_strip_head(BLOCK_FILE_NAME(bp)), BLOCK_LINE_NUM(bp)
		);
	    )
	}
	else
	    mem_printf("Free  %8x    %x", next_free, PREV_FREE(bp));
	mem_printf("\n");
    }

    if (!active)
    {
	mem_puts("");
	mem_show_free();
    }
}


t_void mem_show_blocks()
{
    memi_show_blocks(0);
}

t_void mem_show_active()
{
    memi_show_blocks(1);
}
