#include "mem.h"
 
t_void memi_check_die(s, bp)
char    *s;
t_ptr   bp;
{
    mem_do_enter_check = FALSE;
    DIE("mem_check_workspace(): corrupt %s for block %x\n", s, bp);
}
 
t_int mem_check_workspace()
/*
Check that the current MEM space looks OK (i.e. not corrupted).
*/
{
    t_ptr       bp, high, next, next_free;
 
    bp = memi_base_mem;
    high = memi_high_mem;
 
    while (bp < high)
    {
        next = NEXT_BLOCK(bp);
        if ((int)next % sizeof(t_ptr) || next < bp + HEADER_SIZE || next > high)
            memi_check_die("next block", bp);
 
        if (next < high && PREV_BLOCK(next) != bp)
            memi_check_die("previous block", next);
 
        next_free = NEXT_FREE(bp);
        if ((int)next_free % sizeof(t_ptr))
            memi_check_die("previous free", next_free);
 
        if (IS_ACTIVE(next_free))
        {
            if (DEREF(next_free) != bp)
                memi_check_die("handle entry", bp);
        }
        else if (
            next_free && !IS_SPECIAL(next_free) &&
            PREV_FREE(next_free) != (t_ptr)&NEXT_FREE(bp)
        )
            memi_check_die("previous free", next_free);
 
        bp = next;
    }
 
    return TRUE;
}
 
t_int mem_check_hlist()
/*
Check the free handle list.
*/
{
    t_ptr       hp;
 
    hp = memi_free_handle_list;
    printf("free handle list:");
    while (hp)
    {
        mem_printf(" %x", hp);
        if ((t_int)hp & 3)
            memi_check_die("handle pointer (lie follows) ", hp);
        hp = DEREF(hp);
    }
    mem_puts("");
    return TRUE;
}
 
t_int mem_valid_handle(h)
t_handle        h;
/*
Return whether h is a valid handle.
*/
{
    t_ptr       bp, hp;
 
    HNORMALIZE(h);
    if (h < 1)
        return FALSE;
 
    hp = &HANDLE_BASE[h];
    if (hp >= memi_next_handle)
        return FALSE;
 
    bp = DEREF(hp);
 
    return  bp != P_DELETED_HANDLE &&
            (bp < HANDLE_BASE || bp > memi_handle_limit);
}
 
void f_mem_check_handle(h, file, line)
t_handle        h;
char            *file;
int             line;
{
    if (!mem_valid_handle(h))
        DIE(
            "mem_check_handle: bad handle %d in %s, line %d\n",
            h, mem_strip_head(file), line
        );
}
 
t_void memi_develop_check(func, e, es, h, UFILE, ULINE)
char    *func, *es, *UFILE;
t_int   e, h, ULINE;
{
    if (e)
        return;
 
    printf(
        "%s: assertion %s (%d) failed; called from %s, line %d\n",
        func, es, h, mem_strip_head(UFILE), ULINE
    );
    (*mem_callback)();
}
 
t_void memi_check_handle(func, h, UFILE, ULINE)
char    *func, *UFILE;
t_handle h;
t_int    ULINE;
{
    t_ptr       bp, hp;
    t_handle    hn;
 
    hn = HNORM(h);
    if (hn < 1)
        goto BAD;
 
    hp = &HANDLE_BASE[hn];
    if (hp >= memi_next_handle)
        goto BAD;
 
    bp = DEREF(hp);
 
    if (bp == P_DELETED_HANDLE)
        DIE(
            "%s: deleted handle %d referenced in %s, line %d\n",
            func, h, mem_strip_head(UFILE), ULINE
        );
 
    if (bp < HANDLE_BASE || bp > memi_handle_limit)
        return;
 
BAD:
    DIE(
        "%s: bad handle %d at %s, line %d\n",
        func, h, mem_strip_head(UFILE), ULINE
    );
}
 
t_void memi_assert(e, es, UFILE, ULINE)
t_int   e, ULINE;
char    *es, *UFILE;
{
    if (e)
        return;
 
    DIE(
        "mem: assertion \"%s\" failed; called from %s, line %d\n",
        es, mem_strip_head(UFILE), ULINE
    );
}
 
t_mem_word *f_mem_check_ptr FL2(h, up)
t_handle        h;
void            *up;
/*
Check whether points into the block associated with h.
*/
{
    t_ptr       bp, p;
 
    CHECK_HANDLE("mem_check_ptr", h);
    HNORMALIZE(h);
 
    p = (t_ptr)up;
    bp = HANDLE_ACCESS(h);
 
    CHECK(
        "mem_check_ptr",
        bp <= p && p < LEFTMOST_HEADER(NEXT_BLOCK(bp)),
        HNORM(h)
    );
 
    return (t_mem_word *)p;
}
