/******************************************************************************
  vector_index_init.c
******************************************************************************/
 
#include "stdio.h"        
#include "kant.h"
#include "vector.h"

vector
vector_index_init WITH_2_ARGS(
	integer_small,	length,
	integer_small,	lbound
)
/*******************************************************************************
 
Description:
                
	Initializes an index vector of length "length".
	( Nearly ) all entries of this vector will be set on "lbound".
	Be careful !! The last entry will be "lbound - 1" because
	normally the increment routine is called BEFORE the loop !!

  
Calling sequence:
 
        vector_index_init( length, lbound );
 
        integer_small  	length:    length of vector vec to create
        integer_small  	lbound:    vec := (lbound, ..., lbound, lbound-1)

 
History:

	92-06-11 CO     first version

*******************************************************************************/
{       
	block_declarations;
                          
	vector		vec;  
	integer_small	i;

	vec = vec_new( length ); 
	for( i = 1; i < length; i++ )  vec_entry( vec, i ) = lbound;
	vec_entry( vec, length ) = lbound - 1;

	return( vec );
}
