#include "kant.h"
#include "poly.h"
#include "anf.h"

anf_elt
poly_to_anf_elt WITH_2_ARGS(
	order,		ord,
	t_poly,	pol
)
/*******************************************************************************
 
poly_to_anf_elt.c
 
JS October 1991 
Last modification: 21.10.91
      
Casts the coefficients of the polynomial into an algebraic integer.
The basis of ord must be power basis.
 
The degree of the polynomial must be less than the degree of the order.
 
*******************************************************************************/
{
	block_declarations;         
 
	anf_elt		alpha;
	order		ordcoef;
	integer_small	deg, i, nterms;
	t_handle		polh;
 
 
	if (!order_basis_is_power(ord))
		error_internal("poly_to_anf_elt: Basis is not power basis.");
 
	deg     = order_abs_degree(ord);
	ordcoef = order_coef_order(ord);
 
	if (m_poly_const(pol))
		return anf_elt_incref(pol);
	else
		polh = m_poly_poly_to_handle(pol);
 
	nterms = m_poly_nterms(polh);       
 
	if (m_poly_expt(polh, nterms - 1) >= deg)
		error_internal("poly_to_anf_elt: Polynomial degree too large.");
 
	anf_elt_alloc(alpha, deg);
	anf_elt_den(alpha) = 1;
 
	for (i=1; i<=deg; ++i) anf_elt_coef(alpha, i) = 0;
 
	for (i=0; i<nterms; ++i)
	{
		anf_elt_coef(alpha, m_poly_expt(polh, i)+1) = 
					anf_elt_incref(m_poly_coefft(polh, i));
	}
 
	return alpha;
}
