/******************************************************************************
  order_units_relations.c                                                           
******************************************************************************/
                  
#include "kant.h" 
 
#define DEGFAC     10
#define IDBOUNDMAX 600
 
t_void
order_units_relations WITH_1_ARG(
	order,		ord
)
/*******************************************************************************

Description: 
 
 	Tries to compute an independent system of units
        in ord (which probably will be a fundamental system).
        This function computes a factor basis and then tries
        to find sufficient relations ("S-units") which are then evaluated.
 
        The relations are looked for by computing numbers whose T2 value
        is the root of the Minkowski (or a related) bound, but not less than
        DEGFAC*degree and not more than IDBOUNDMAX.
  
        The choice of the upper T2 bound is not at all optimized!
 
Calling sequence: 
	
	order_units_relations(ord);
                               
	order		ord    = t_handle of the order 

  
History:

 	92-06-10 JS 	more intelligent (?) bound finding technique
 	92-05-15 JS 	retry if system not maximal
 	92-05-07 JS 	first version
  
*******************************************************************************/
{
	block_declarations;
 
        integer_big     t2, idbound, temp, mink;
        integer_small   sign, numid, r, numrel, deg, minum;
                                                           
        deg 	= order_abs_degree(ord);
        r 	= order_r(ord);
        mink    = order_minkowski_bound(ord);
        integer_root(mink, 2, &idbound, &sign);
 
        if (integer_compare(idbound, DEGFAC*deg) < 0)
	{
	        temp    = idbound;
		idbound = DEGFAC*deg;
		integer_delref(temp);
        }
 
        if (integer_compare(idbound, IDBOUNDMAX) > 0)
	{
	        temp    = idbound;
		idbound = IDBOUNDMAX;
		integer_delref(temp);
        }

        order_fac_basis_create(ord, idbound);
        
        numid 	= order_fac_basis_ideals_count(ord);   
        minum 	= (r > 4) ? 4 * r : 15;
        numrel 	= ((int) (minum/numid)) + 2;
 
        if (order_torsion_rank(ord) > 2) numrel *= 2;
 
        t2 = 0;
        order_relations_find(ord, t2, numrel);
 
        order_relation_eval_units(ord);
 
/* 
  retry?
*/
        if (!order_units_are_maximal(ord)) 
	{        
                if (anf_print_level > 0) puts("Retry of unit computation...");
		numrel *= 2;
	        order_relation_delete(ord);
	        order_relations_find(ord, t2, numrel);
	        order_relation_eval_units(ord);
	}
        if (!order_units_are_maximal(ord)) 
	{
                if (anf_print_level > 0) puts("Retry of unit computation...");
		numrel *= 2;
	        order_relation_delete(ord);
	        order_relations_find(ord, t2, numrel);
	        order_relation_eval_units(ord);
	}
 
        integer_delref(t2);
        integer_delref(mink);
        integer_delref(idbound);
 
	return;
}
