/******************************************************************************
  order_trace_mat.c
******************************************************************************/
#include "kant.h"
#include "mat.h"
#include "anf.h"


matrix
order_trace_mat WITH_1_ARG (
	order,		ord
)

/******************************************************************************
 
Description:	Computes the integer matrix

                ( Tr(w1*w1) .... Tr(wn*w1) )
                (                          )
                (     :               :    )
                (                          )
                ( Tr(w1*wn) .... Tr(wn*wn) )

		where w1,...,wn is the Z-basis of the passed order
 
Calling sequence:
 
	mat = order_trace_mat(ord)

	matrix		mat	= t_handle of matrix (see above)
	order		ord	= t_handle of order
 
History:
 
	92-02-28 KW    written
 
******************************************************************************/
{
	block_declarations;

	anf_elt		alpha;
	integer_small	deg;
	integer_small	i,j,k;    
	matrix		trace_mat;

	deg = order_rel_degree(ord);

	trace_mat = mat_new(deg,deg);

	anf_elt_alloc(alpha,deg);

/*
*	simple linear algebra
*/
	for(i=1;i<=deg;i++)
	{
		for(j=1;j<i;j++)
		{
			for(k=1;k<=deg;k++)
			{
				anf_elt_coef(alpha,k) = mat_elt(order_mult_matrix(ord,i),k,j);
			}
			mat_elt(trace_mat,i,j) = anf_trace(ord,alpha);
/*
*	trace_mat is symmetric.
*/
			mat_elt(trace_mat,j,i) = integer_incref(mat_elt(trace_mat,i,j));
		}
	}

	for(i=1;i<=deg;i++)
	{
		for(k=1;k<=deg;k++)
		{
			anf_elt_coef(alpha,k) = mat_elt(order_mult_matrix(ord,i),k,i);
		}
		mat_elt(trace_mat,i,i) = anf_trace(ord,alpha);
	}

/*
*	Reset coefs of alpha to delete alpha
*/
	for (k=1;k<=deg;k++) anf_elt_coef(alpha,k) = 0;
	anf_elt_delete(ord,&alpha);

	return (trace_mat);
}
