/******************************************************************************
  order_relation_eval_class_group.c                                                           
******************************************************************************/
 
#include "kant.h"

t_void
order_relation_eval_class_group WITH_1_ARG(
	order,		ord
)
/*******************************************************************************

Description: 
                                       
	If not enough relations are provided the class number is set to zero.

	[PZ] =	Pohst/Zassenhaus:
		Algorithmic Algebraic Number Theory,
		Cambridge Univ. Press 1989.

Calling sequence: 
	
	order_relation_eval_class_group(ord);
                               
	order	ord    = t_handle of the order 
 
History:

	93-02-15 KW	continued...
	92-09-01 JS	setting order structure parameters
	92-06-03 JS	Smith normal form
	92-05-07 JS	first version
  
*******************************************************************************/
{
	block_declarations;
  
	anf_elt		gamma;
	anf_ideal	id;
	faclst		fax;
	integer_big	h,rem,tempa,tempb,tempc,tempd;
	integer_small	i,j,k,ii,jj,kk,idcnt,rcnt;
	matrix		cgm,cgmn,mat1,mat2,trans1,trans2;
	t_handle	Z;
	vector		clgen,clgenn,hv,iv,v,w;
 
	if (anf_print_level > 0)
		printf("Entering order_relation_eval_class_group...\n");

	Z = structure_z;
	idcnt	= order_fac_basis_ideals_count(ord);
	rcnt  	= order_relation_count(ord);
	mat1   	= order_relation_mat(ord);
 
	if (!mat1 || !rcnt || (rcnt < idcnt)) return;
 
/*
**	Starting HNF reduction of relation matrix...
*/
	if (anf_print_level > 1)
	{
		printf("relation matrix:\n");
		mat_ring_write(Z,mat1);
		printf("Starting HNF reduction of relation matrix...\n");
	}
	trans1 = mat2 = 0;
	mat_ring_hnf_col_sub(Z,mat1,&mat2,&trans1,FALSE);
	
/*
**	Initialize class-group-matrix
*/
        cgm = mat_ring_submat(Z,mat2,1,1,idcnt,idcnt);
	if (anf_print_level > 0)
	{
		printf("class-group-matrix:\n");
		mat_ring_write(Z,cgm);
	}
	mat_delref(Z,&mat2);

/*
**	Is the class-group-matrix regular ?
*/
	h = 1;
	for (i=1;i<=idcnt;i++)
	{
		tempa = h;
		h = integer_mult(h,mat_elt(cgm,i,i));
		integer_delref(tempa);
	}

	if (anf_print_level > 0)
	{
		switch (h)
		{
		case 0 :	printf("Class group: Not enough relations found.\n");
				break;
		case 1 :	printf("Class group is trivial.\n");
				break;
		default:	cay_print("Class number is a divisor of %d.\n",h);
		}
	}

	if ((h==1) || (!h))
	{
                order_class_number(ord) = h;
		mat_delref(Z,&cgm);
		return;
        }

/*
**	Calculate the reduced class-group-matrix deleting trival diagonal entries.
*/
	v = vec_new(idcnt);
	for (k=0,i=1;i<=idcnt;i++) 
	{
		if (mat_elt(cgm,i,i) != 1)
		{
			vec_entry(v,i) = TRUE;
			k++;
		}
		else vec_entry(v,i) = FALSE;
	}
	clgen = vec_new(k);
	cgmn  = mat_new(k,k);
	for (ii=i=1;i<=idcnt;i++)
	{
		if (!vec_entry(v,i)) continue;
		for(jj=j=1;j<=idcnt;j++)
		{
			if(!vec_entry(v,j)) continue;
			mat_elt(cgmn,ii,jj++) = integer_incref(mat_elt(cgm,i,j));
		}
		vec_entry(clgen,ii++) = anf_ideal_incref(order_fac_basis_ideal(ord,i));
	}
	vec_delete(Z,&v);
	mat_delref(Z,&cgm);
	cgm = cgmn;
	idcnt = k;

	if (anf_print_level > 0)
	{
		printf("Reduced class-group-matrix (first step):\n");
		mat_ring_write(Z,cgm);
	}

/*
**	last row
*/
	do
	{
/*
**		tempa gets the order of the last ideal.
*/
		tempa = integer_incref(mat_elt(cgm,k,k));
		integer_lst_factorise(tempa,&fax,&rem,50,1000,262144,0,0,0,0,tempa,0);
		if (rem) error_internal("eval_class_group: No hope !");
		j = faclst_num_prime(fax);
		for (i=1;i<=j;i++)
		{
			if (!faclst_expon(fax,i-1)) continue;
			faclst_expon(fax,i-1)--;
			tempb = integer_div(tempa,faclst_prime(fax,i-1));
			id = anf_ideal_power(ord,vec_entry(clgen,k),tempb);
			if (anf_print_level > 0) printf("Principal ???...\n");
			if (anf_ideal_is_principal(ord,id,&gamma))
			{
				anf_elt_delete(ord,&gamma);
				integer_delref(tempa);
				tempa = tempb;
				i--;
			}
			else integer_delref(tempb);
			anf_ideal_delete(ord,&id);
		}
		faclst_delete(&fax);		
/*
**		If the order equals 1 we can delete the last row
*/
		if (tempa == 1)
		{
			mat_ring_diminish(Z,&cgm,k,k);
			clgenn = vec_new(k-1);
			for(i=1;i<k;i++)
			{
				vec_entry(clgenn,i) = vec_entry(clgen,i);
				vec_entry(clgen,i) = 0;
			}
			anf_ideal_delete(ord,&vec_entry(clgen,k));
			vec_delete(Z,&clgen);
			clgen = clgenn;
			idcnt--;
		}
		else
		{
			integer_delref(mat_elt(cgm,k,k));
			mat_elt(cgm,k,k) = tempa;
			for (i=1;i<k;i++)
			{
				tempb = mat_elt(cgm,k,i);
				mat_elt(cgm,k,i) = integer_rem(tempb,tempa);
				integer_delref(tempb);
			}
		}
		k--;
	} while ((k) && (k == idcnt));

	if (anf_print_level > 0)
	{
		if (cgm)
		{
			printf("Reduced class-group-matrix (second step):\n");
			mat_ring_write(Z,cgm);
		}
		else printf("Class group is trivial.\n");
	}

/*
**	Inductive procedure ([PZ, p.418])
*/
	while (k)
	{
		integer_lst_factorise(mat_elt(cgm,k,k),&fax,&rem,50,1000,262144,0,0,0,0,mat_elt(cgm,k,k),0);
		if (rem) error_internal("eval_class_group: No hope !");
		j = faclst_num_prime(fax);

		kk = idcnt-k+1;
		iv = vec_new(kk);
		for (ii=1;ii<=kk;ii++) vec_entry(iv,ii) = vec_entry(clgen,k+ii-1);

		for (i=1;i<=j;i++)
		{
			if (!faclst_expon(fax,i-1)) continue;

/*
**			Initialize exponent vector
*/
			hv = vec_new(kk);
			faclst_expon(fax,i-1)--;
			vec_entry(hv,1) = integer_div(mat_elt(cgm,k,k),faclst_prime(fax,i-1));
			for (ii=2;ii<=kk;ii++) vec_entry(hv,ii) = 0;
			h = 1;

			while (h)
			{
				if (anf_print_level > 1) { printf("exponent vector: "); mat_ring_write(Z,hv); }

				tempd = 0;
				for(jj=2;(!tempd) && (jj<=kk);jj++)
				{
					tempb = integer_mult(vec_entry(hv,jj),faclst_prime(fax,i-1));
					tempc = integer_subtract(mat_elt(cgm,k+jj-1,k),tempb);
                    			tempd = integer_rem(tempc,mat_elt(cgm,k+jj-1,k+jj-1));
					integer_delref(tempb);
					integer_delref(tempc);
					integer_delref(tempd);
				}

				if (!tempd)
				{
					id = anf_ideal_power_product(ord,iv,hv);
					if (anf_print_level > 0) printf("Principal ??...\n");
					if (anf_ideal_is_principal(ord,id,&gamma)) goto NILREB;
					anf_ideal_delete(ord,&id);
				} else if (anf_print_level > 1) printf("exponent vector is bad.\n");
				
/*
**				Next exponent vector
*/
				tempa = vec_entry(hv,2);
				tempb = integer_add(tempa,1);
				vec_entry(hv,2) = integer_rem(tempb,mat_elt(cgm,k+1,k+1));
          			integer_delref(tempa);
          			integer_delref(tempb);
				for(jj=3;!vec_entry(hv,jj-1) && (jj<=kk);jj++)
				{
					tempa = vec_entry(hv,jj);
					tempb = integer_add(tempa,1);
					vec_entry(hv,jj) = integer_rem(tempb,mat_elt(cgm,k+jj-1,k+jj-1));
          				integer_delref(tempa);
          				integer_delref(tempb);
				}
/*
**				All entries zero ?
*/
				h = 0;
				for(jj=2;(!h) && (jj<=kk);jj++) if (vec_entry(hv,jj)) h++;
			}
			vec_delete(Z,&hv);
			continue;

NILREB:			anf_elt_delete(ord,&gamma);
			anf_ideal_delete(ord,&id);
			for (jj=1;jj<=kk;jj++)
			{
				integer_delref(mat_elt(cgm,k+jj-1,k));
				mat_elt(cgm,k+jj-1,k) = integer_incref(vec_entry(hv,jj));
			}
			vec_delete(Z,&hv);
			i--;
		}
		faclst_delete(&fax);

		mat1 = mat_ring_submat(Z,cgm,k,k,kk,kk);
		trans1 =  mat_ring_create_id(Z,kk);
		trans2 = 0;
		mat_z_smith(mat1,&mat2,&trans1,&trans2);
		trans2 = mat_z_inverse(Z,trans1);

		if (anf_print_level > 2)
		{
			printf("Smith-reduced:\n");
			mat_ring_write(Z,mat2);
			printf("Left transformation matrix:\n");
			mat_ring_write(Z,trans1);
			printf("Inverse of the left transformation matrix:\n");
			mat_ring_write(Z,trans2);
		}

/*
**		transformations
*
*
**		Set new generators ([PZ, p.420 (5.16c)])
*/
		for (j=1;j<=kk;j++)
		{
/*
**			Get positiv entries in column j of trans 2.
*/
			do
			{
				ii = 0;
				for (i=1;!ii && i<=kk;i++) if (integer_compare(mat_elt(trans2,i,j),0) == -1) ii++;
				if (!ii) continue;
				for (i=1;i<=kk;i++)
				{
					tempa = mat_elt(trans2,i,j);
					tempb = (mat_elt(cgm,k+i-1,k))	? mat_elt(cgm,k+i-1,k)
									: mat_elt(cgm,k+i-1,k+i-1);
          				mat_elt(trans2,i,j) = integer_add(tempa,tempb);
          				integer_delref(tempa);
				}
			} while(ii);
/*
**			Set new generator.
*/
			v = mat_ring_col_to_vector(Z,trans2,j);
			vec_entry(clgen,k+j-1) = anf_ideal_power_product(ord,iv,v);
			vec_delete(Z,&v);
		}
		for (j=1;j<=kk;j++) anf_ideal_delete(ord,&vec_entry(iv,j));
		vec_delete(Z,&iv);

		if (anf_print_level > 3)
		{
			printf("Inverse of the left transformation matrix after getting positive:\n");
			mat_ring_write(Z,trans2);
		}
/*
**		Update the class-group-matrix ([PZ] p.420, (5.17a)-(5.17d))
*/
		for(j=1;j<k;j++)
		{
			v = vec_new(kk);
			for (i=1;i<=kk;i++) vec_entry(v,i) = mat_elt(cgm,k+i-1,j);
			w = mat_vector_col_mult(Z,trans1,v);
			for (i=1;i<=kk;i++) mat_elt(cgm,k+i-1,j) = integer_incref(vec_entry(w,i));
          		vec_delete(Z,&v);
          		vec_delete(Z,&w);
		}
		for (i=k;i<=idcnt;i++)
		{
			integer_delref(mat_elt(cgm,i,i));
			mat_elt(cgm,i,i) = integer_incref(mat_elt(mat2,i-k+1,i-k+1));
			for (j=1;j<k;j++)
			{
				tempa = mat_elt(cgm,i,j);
				mat_elt(cgm,i,j) = integer_rem(tempa,mat_elt(cgm,i,i));
				integer_delref(tempa);
			}
		}
		for (i=k+1;i<=idcnt;i++)
		{
			integer_delref(mat_elt(cgm,i,k));
			mat_elt(cgm,i,k) = 0;
		}
		mat_delref(Z,&mat1);
		mat_delref(Z,&mat2);
		mat_delref(Z,&trans1);
		mat_delref(Z,&trans2);

		if (anf_print_level > 0)
		{
			printf("new class-group-matrix (after Smith):\n");
			mat_ring_write(Z,cgm);
		}

		while (!integer_compare(mat_elt(cgm,k,k),1))
		{
			mat_ring_diminish(Z,&cgm,k,k);
			if (anf_print_level > 0)
			{
				printf("new class-group-matrix (reduced):\n");
				mat_ring_write(Z,cgm);
			}

			clgenn = vec_new(idcnt-1);
			for (i=1;i<k;i++)
			{
				vec_entry(clgenn,i) = vec_entry(clgen,i);
				vec_entry(clgen,i) = 0;
			}
			anf_ideal_delete(ord,&vec_entry(clgen,k));
			for (i=k+1;i<=idcnt;i++)
			{
				vec_entry(clgenn,i-1) = vec_entry(clgen,i);
				vec_entry(clgen,i) = 0;
			}
			vec_delete(Z,&clgen);
			clgen = clgenn;
			idcnt--;
		}
		k--;
	}
/*
**	Set data
*/
	order_class_group_genexps(ord) = cgm;         
	order_class_group_gen_count_set(ord,idcnt);
	order_class_group_order_set(ord,idcnt);
	h = 1;
	for (i=1;i<=idcnt;i++)
	{
		order_class_group_gen(ord,i) = vec_entry(clgen,i);
		anf_ideal_2_assure(ord,order_class_group_gen(ord,i));
		vec_entry(clgen,i) = 0;
		order_class_group_factor_order(ord,i) = integer_incref(mat_elt(cgm,i,i));
		tempa = h;
		h = integer_mult(h,mat_elt(cgm,i,i));
		integer_delref(tempa);
	}
	order_class_number(ord) = h;

	if (anf_print_level > 0)
	{
		if (cgm)
		{
			cay_print("Class number is %d.\n",h);
			printf("Reduced class-group-matrix (finished):\n");
			mat_ring_write(Z,cgm);
		}
		else printf("Class group is trivial.\n");
	}
	vec_delete(Z,&clgen);

        return;
}

