/******************************************************************************
  order_relation_delete.c                                                           
******************************************************************************/
 
#include "kant.h"
 
t_void
order_relation_delete WITH_1_ARG(
	order,		ord
)
/*******************************************************************************

Description: 
 
        Deletes all data in the order referring to relations
        ("S-units"). This function does not delete the factor basis.
 
Calling sequence: 
	
	order_relation_delete(ord);
                               
	order		ord    = t_handle of the order 
 
History:

 	92-05-06 JS 	first version
  
*******************************************************************************/
{
	block_declarations;
  
        t_handle          Z;
 
        Z = m_z_str_incref(structure_z);
 
        if(order_relation_mat(ord))
	        mat_delref(Z, &order_relation_mat(ord));
 
        if(order_relation_numbers(ord))
	        vec_delete(ord, &order_relation_numbers(ord));
 
        if(order_relation_trans_mat(ord))
	        mat_delref(Z, &order_relation_trans_mat(ord));
 
        order_relation_status(ord) = 0;
        order_relation_count(ord) = 0;
 
        ring_delref(&Z);
 
        return;
}
