#include "kant.h"

t_logical
order_db_find_2 WITH_2_ARGS(
        integer_big,    disc,
        order *,        ord2)

/*********************************************************************************

Description:
        
        Returns TRUE if a quadratic field with discriminant disc exists.
        Then the maximal order of the field will be returned.
        
        If disc is divisible by 4  or disc is not squarefree the routine 
        returns FALSE.

Calling sequence: 

        L = order_db_find_2(disc, &ord2);

        t_logical         L       = TRUE or FALSE
        integer_big     disc    = discriminant
        order           ord2    = maximal order of quadratic field
       
History:

	92-07-08 JPS written
*********************************************************************************/
        {
	block_declarations;

	integer_big		d,quot,rem;
        order                   eqn_ord;
        t_poly               pol, old;
        t_handle                  Z;
        t_logical                 L;  

/*      Testing wether disc is squarefree or divisible by 4 */

        integer_quot_rem(disc, 4, &quot, &rem);
        if (rem == 1)   
                if (integer_is_squarefree(disc)) 
                        { 
                        d = integer_incref(disc);
                        }
                else 
                        {
                        integer_delref(quot);
                        integer_delref(rem);
                        return FALSE;
                        }
        else 
                if (rem == 0)
                        {
                        if (integer_is_squarefree(quot))
                                { 
                                d = integer_incref(quot);
                                } 
                        else
                                {
                                integer_delref(quot);
                                integer_delref(rem);
                                return FALSE; 
                                }
                        }
                else  
                        {
                        integer_delref(quot);
                        integer_delref(rem);
                        return FALSE; 
                        }  
/*    disc seeems to work. We start to compute the quadratic order. */
        Z = m_z_str_incref(structure_z);
        m_poly_u_create_empty(&pol, 3);
        m_poly_coefft(pol, 1) = 1 ;
        m_poly_expt(pol, 1) = 2;
        m_poly_coefft(pol, 0) = integer_negate(d);
        m_poly_expt(pol, 0) = 0;
        old = pol;
        pol = poly_z_clean(structure_pring_z, m_poly_handle_to_poly(pol) ); 
        m_poly_z_delref(structure_pring_z, old);
        eqn_ord = order_equation_create(Z, pol);
        *ord2 = order_maximal(eqn_ord);
        order_delete(&eqn_ord);
        m_poly_z_delref(structure_pring_z, pol);
        integer_delref(d);
        integer_delref(quot);
        integer_delref(rem);
        ring_delete(&Z);
        return TRUE;
        } 
