#include <stdio.h>         
#include "kant.h" 
#include "anf.h" 
#include "real.e"


anf_elt
order_basis_elt  WITH_2_ARGS(
	order,		ord,
	integer_small,	i
)
/*******************************************************************************
 
Description:
 
	The function returns the i-th basis element of the order ord.

 
Calling sequence:
 
	alpha= order_basis_elt(ord, i);
 
      	order  	        ord      = t_handle of an order 
	integer_small   i	 = the i-th basis element of ord
      	anf_elt         alpha    = t_handle of an algebraic number in ord
      
 
History:
                
        93-02-25 MD    order_abs_degree --> order_rel_degree
	92-04-01 AJ    written
 
*******************************************************************************/
{  
	block_declarations;         

  	int		j, n;
	anf_elt		alpha;   
                                    

/*** Initialisation  **********************************************************/

	n= order_rel_degree(ord);  


/*** The i-th basis element  **************************************************/
 
	anf_elt_alloc(alpha, n);

  	anf_elt_den(alpha)= 1;

	for(j=1;j<=n;j++)
	  anf_elt_coef(alpha,j)= 0;

	anf_elt_coef(alpha, i)= 1;

	
/*** End:  ***********************************************/

	return alpha;

} 

