/*******************************************************************************
  mat_z_simplify.c
********************************************************************************/

#include "kant.h"     
#include "integer.e"
#include "mat.h"
#include "mat.e"                         


void mat_z_simplify WITH_3_ARGS (t_handle        , cring ,
                                 matrix        , mat   ,
                                 integer_big * , denom )
/*******************************************************************************
Description:               
   
   Simplifies a given matrix together with a main denominator.
   NO checking is done whether cring is the ring of integers.


Calling sequence:            
        
       t_handle            cring   : the ring of integers
       matrix            mat     : matrix that has to be simplified.
       integer_big       *denom : the main denominator of mat.
                                       
                                                                          

     mat_z_simplify (cring,mat,denom);

                                                                     
History:  
                                                               
       MD 91-11-01         : first version                
  
********************************************************************************/
{
       block_declarations;

       integer_small i,j,n,m;
       integer_big   temp,gcd;



  temp = integer_matrix_gcd  (cring,mat);
  
  if (temp > 1) 
  {
    gcd = integer_gcd (*denom,temp);
    integer_delref (temp);
       
    if (gcd >1) 
    {
      n = mat_row (mat);
      m = mat_col (mat);
        

      for (i=1;i<=n;i++)
        for (j=1;j<=m;j++)
        {
          temp = mat_elt (mat,i,j);
          mat_elt (mat,i,j) = integer_div  (mat_elt(mat,i,j),gcd);
          integer_delref (temp);
        }
      temp = *denom;
      *denom = integer_div (*denom,gcd);
      integer_delref (temp);
      integer_delref (gcd);
   
    }
  }
}
