#include "kant.h"
#include "mat.h"
#include "anf.h"


anf_elt
mat_real_col_to_anf_con WITH_3_ARGS(
	order,		ord,
	matrix,	        mat,
	integer_small,	colno
)
/*******************************************************************************
 
mat_real_col_to_anf_con.c
 
JS October 1991
Last modification: 09.10.91

Converts column colno of mat into a conjugate vector of an algebraic number.
The row dimension of mat must coincide with the relative degree of ord.
The elements of the matrix must be of type t_real.
  
*******************************************************************************/
{
	block_declarations;
 
	anf_elt		alpha;
	integer_small	deg;
	integer_small	i;
 
 
	deg = order_abs_degree(ord);
 
	anf_con_alloc(alpha, deg);
 
	for (i=1; i<=deg; ++i)
		anf_con(alpha, i) = real_incref(mat_elt(mat, i, colno));
 
	return alpha;
}
 


