#include "kant.h"
#include "mat.h"
#include "anf.h"


anf_elt
mat_order_col_to_anf_elt WITH_3_ARGS(
	order,		ord,
	matrix,	        mat,
	integer_small,	colno
)
/*******************************************************************************
 
mat_order_col_to_anf_elt.c
 
JS September 1991
Last modification: 24.09.91

Converts column colno of mat into an algebraic number with denominator 1.
The matrix entries must be elements of the coefficient order of ord and
the row dimension of mat must coincide with the relative degree of ord.
  
*******************************************************************************/
{
	block_declarations;
 
	anf_elt		alpha;
	integer_small	deg;
	integer_small	i;
 
 
	deg = order_rel_degree(ord);
 
	anf_elt_alloc(alpha, deg);
 
	for (i=1; i<=deg; ++i)
		anf_elt_coef(alpha, i) = anf_elt_incref(mat_elt(mat, i, colno));
	anf_elt_den(alpha) = 1;
 
	return alpha;
}
 


