/******************************************************************************
  lat_create.c
******************************************************************************/
#include "kant.h"
#include "lattice.h"

lattice
lat_create WITH_NO_ARGS(
)
/******************************************************************************
 
Description:	Allocating space for a lattice
		The task of this routine is to allocate sufficient space for
		the table which describes a lattice. 
 
		The invariants of the lattice are set to void.
 
Calling sequence:
 
		lat = lat_create()

		lattice		lat	= t_handle of the new lattice
 
History:
 
	92-02-28 KW    minor changes
	92-01-02 JS    written
 
******************************************************************************/
{
	lattice lat;

	lat = mem_alloc_zero(sizeof(lattice_struct));
 
	block_init(lat, LATTICE_BLOCK_TYPE);

	lat_rank(lat)		= -1;
 
	lat_basis(lat)		= MEM_NH;
	lat_basis_ring(lat)	= MEM_NH;
  
	lat_gram(lat)		= MEM_NH;
	lat_gram_ring(lat)	= MEM_NH;
 
	lat_chol(lat)		= MEM_NH;
	lat_chol_ring(lat)	= MEM_NH;

	lat_double_chol(lat)	= MEM_NH;

	lat_disc(lat)		= MEM_NH;
	lat_disc_ring(lat)	= MEM_NH;

	lat_succ_mins(lat)	= MEM_NH;
	lat_succ_mins_vecs(lat) = MEM_NH;

	return lat;
}
