/*******************************************************************************
  disc_factors_strip.c 
********************************************************************************/
#include "kant.h" 

t_logical
disc_factors_strip WITH_2_ARGS (order   ,  start,
                                faclst* ,  factors )
/*******************************************************************************

Description:

   Check all given primes p , if the p-maximal overorder is  
   (or might be) not the equation-order. If the order start  
   is the equation order we use the Dedekind test to get a   
   solution. Otherwise we simply check if p^2 divides the    
   discriminant. 
   If the function can't find such primes it will return FALSE.
    

Calling sequence:

                    order     start            : all arithmetic is done within 
                                                 this order.
                    faclst    *factors         : the factorisation of the discriminant
                                                 of the given order.  

                    t_logical   there_are_primes : return value of function.
    
          there_are_primes = disc_factors_strip (start,factors);

    The procedure returns all primes in the factorisation with a possibility 
    that start is not p-maximal.
    All these primes are returned in the list factors.
    

History:
                                                         
     JS 92-03-12       no incref when getting order_poly
     MD 92-01-15       first version : dedekind-test used.                                               

********************************************************************************/
{
	block_declarations;         
        
        faclst          a; 
        t_poly       polynomial;
        t_logical         is_maximal;    
        integer_big     prime;
        integer_small   ind_a,i,exp_of_prime,maxx;
      
  maxx = faclst_num_prime(*factors);

/* We can't use more  than maxx pairs of (prime,expo.)   */

  a = faclst_alloc (maxx); 
  ind_a = 0;                 

  if ( order_basis_is_power(start) )
    for (i=0; i<maxx; i++)
    {
      exp_of_prime = faclst_expon(*factors,i);   
           
      if (exp_of_prime >= 2)                  
      {              
        prime        = faclst_prime(*factors,i); 
        polynomial   = order_poly (start);

        is_maximal   = (integer_is_single(prime))
                       ? poly_z_dedekind_test(structure_pring_z, polynomial,prime)
                       : FALSE;
        if (!is_maximal) 
        {
          faclst_prime (a,ind_a) = prime;
          faclst_expon (a,ind_a) = exp_of_prime;
          ind_a++;
        }
      }
    }
  else
    for (i=0; i<maxx; i++)
    {
      exp_of_prime = faclst_expon(*factors,i);   
           
      if (exp_of_prime >= 2)                  
      {              
          faclst_prime (a,ind_a) = faclst_prime(*factors,i); 
          faclst_expon (a,ind_a) = exp_of_prime;
          ind_a++;
      }
    }

  faclst_delete (factors);

/* We now got the set set of all primes p with R(p) is (or might be) not maximal */
    
  if (ind_a > 0)
  {                                                            

    *factors = faclst_alloc (ind_a);

    for (i=0; i<ind_a; i++)
    {                         
      faclst_prime (*factors,i) = integer_incref (faclst_prime (a,i));
      faclst_expon (*factors,i) = integer_incref (faclst_expon (a,i));
    }                               
    faclst_num_prime (*factors) = ind_a;        
    faclst_delete (&a);

    return TRUE;
  }

  return FALSE;
}               





