/* JS 10/9/92 

Useful functions for accessing and assuring anf and order data.
In most of the cases the submitted handles can either be orders or anfs.
 
Contains:
	anf          	anf_create_poly(poly) 
	order          	anf_order_equation(field) 
	order          	anf_order_maximal(h)    
	integer_small  	anf_order_degree_abs(h)
	t_void           	anf_order_sig(h, &r1, &r2, &r3)
	integer_big    	anf_order_disc(h)
	dyn_arr_handle 	anf_order_integral_basis(h)
	dyn_arr_handle 	order_basis(h)
	integer_big    	anf_order_class_number(h)
        t_real         	anf_order_reg(h)
	dyn_arr_handle  anf_order_mult_table(h)
        t_void            anf_print_level_set(value)
*/
       
 
#include "kant.h"

anf 
anf_create_poly(ordcoef, pol)                 /* returns number field */
        order		ordcoef;              
        t_poly	pol;
{        
        order	ord;

/* Attention: increments the equation order of ord which is hidden on exit.
   This may cause trouble when deleting. I do not see a better way by now. 
   So when you delete the number field the order will still exists although
   there is no t_handle access to it. On the other hand, if we would delref
   the order here there would not be any equation order in the field. */

 
        ord = order_equation_create(ordcoef, pol);
 
        return anf_incref(order_anf(ord));
}

  
order 
anf_order_equation(field)                 /* returns (first) equation order */
        anf		field;
{        
        integer_small   i;
 
        i = 1;
        while (!order_basis_is_power(anf_order(field, i))) i++;
 
        return order_incref(anf_order(field, i));
}

  

order 
anf_order_maximal(h)                      /* returns (first) maximal order */
        t_handle	h;
{        
        order   	ord1, ord2;
        integer_small   i, count;

        if (handle_is_anf(h))
        {	
                count = anf_order_count(h);
		IF_DEBUG_FLAG(DEBUG_KANT,
                {
                        cay_print("Looking at stored orders of  Anf\n ");
                }
                )

		for (i=1; i<=count; i++)
                {
			IF_DEBUG_FLAG(DEBUG_KANT,
                        {
                                cay_print("Looking at stored order number %d, handle %d\n ",i, anf_order(h, i));
                        }
                        )

                        if (order_is_maximal(anf_order(h, i)))
                                return order_incref(anf_order(h, i));
                }
                ord1 = anf_order_equation(h);
                ord2 = order_incref(order_maximal(ord1));
                ring_delete(&ord1);
                return ord2;

        }
        else if (order_is_maximal(h))
                return order_incref(h);
        else
                return order_maximal(h);
}


integer_small
anf_order_degree_abs(h)                   /* returns absolute degree */
        t_handle	h;
{                         
        order           ord;
        integer_small   deg;
                            
        if (handle_is_anf(h)) 
		ord = anf_order_equation(h);      
        else
                ord = order_incref(h);
 
        if ((deg = order_abs_degree(ord)) < 0)
        {
                deg = order_rel_degree(ord) * 
		      order_abs_degree(order_coef_order(ord));
                order_abs_degree(ord) = deg;
        }
        ring_delete(&ord);
 
        return deg;
}
 
 

t_void
anf_order_sig(h, r1, r2, r)            /* returns signature */
        t_handle	h;
        integer_small *r1, *r2, *r;
{                         
        order           ord;
                            
        if (handle_is_anf(h)) 
		ord = anf_order_equation(h);      
        else
                ord = order_incref(h);

        order_sig_assure(ord);  
 
        *r1 = order_r1(ord);
        *r2 = order_r2(ord);
        *r  = order_r(ord);
 
        ring_delete(&ord);
 
        return;
}
 

integer_big
anf_order_disc(h)                          /* returns discriminant */
        t_handle	h;
{                         
        block_declarations;
        order           ord;       
        integer_big     disc;
                            
        if (handle_is_anf(h)) 
		ord = anf_order_equation(h);      
        else
                ord = order_incref(h);

        order_disc_assure(ord);  
 
        disc = integer_incref(order_disc(ord));
 
        ring_delete(&ord);
 
        return disc;
}

dyn_arr_handle
order_basis(ord)     		/* returns order basis in terms of 
					standard equation order */
        order 	ord;
{                         
        block_declarations;
 
        order           ord0, ordmax;       
        dyn_arr_handle  omegas;
        anf_elt         alpha;
        integer_small   deg, i;
 
	ord0 = anf_order_equation(order_anf(ord));
 
        deg = order_rel_degree(ord);
 
        omegas = dyn_arr_alloc(deg);
        dyn_arr_curr_length(omegas) = deg;
                                          
        for (i=0; i<deg; ++i)
        {                       
                alpha = order_basis_elt(ord, i+1);
	        dyn_arr_element(omegas, i) = anf_elt_move(ord, alpha, ord0);
                anf_elt_delete(ord, &alpha);
        }
 
        ring_delete(&ord0);
 
        return omegas;
}

dyn_arr_handle
anf_order_integral_basis(h)         /* returns integral basis in terms of
					            standard equation order */
        t_handle	h;
{                         
        block_declarations;
 
        order           ordmax;       
        dyn_arr_handle  omegas;
 
	ordmax = anf_order_maximal(h);
 
        omegas = order_basis(ordmax);
 
        ring_delete(&ordmax);
 
        return omegas;
}


integer_big
anf_order_class_number(h)                          /* returns class number */
        t_handle	h;
{                         
        block_declarations;
        order           ord;       
        integer_big     hf;
                            
        if (handle_is_anf(h)) 
		ord = anf_order_maximal(h);      
        else
                ord = order_incref(h);

        order_class_group_calc(ord);  
 
        hf = order_class_number(ord);
 
        ring_delete(&ord);
 
        return hf;
}

t_void
anf_order_regulator(h, R, reg)                    /* returns regulator */
        t_handle	h;
        t_handle        *R;
        t_real          *reg;
{                         
        block_declarations;
        order           ord;       
                            
        if (handle_is_anf(h)) 
		ord = anf_order_maximal(h);      
        else
                ord = order_incref(h);

        order_unit_group_calc(ord);  
 
        *reg = real_incref(order_reg(ord));
        *R   = ring_incref(order_reals(ord));

        ring_delete(&ord);
 
        return;
}


dyn_arr_handle
anf_order_mult_table(h)                          /* returns multiplication table */
        t_handle	h;
{                         
        block_declarations;
        order           ord;       
        integer_small   deg, i;
        dyn_arr_handle  tab;
                            
        if (handle_is_anf(h)) 
		ord = anf_order_equation(h);      
        else
                ord = order_incref(h);
 
        if (!order_mult_table_known(ord)) order_mult_table_alloc(ord);
 
        deg = order_rel_degree(ord);
 
        tab = dyn_arr_alloc(deg);
        dyn_arr_curr_length(tab) = deg;
 
        for (i=0; i<deg; ++i)
                dyn_arr_element(tab, i) = mat_incref(order_mult_matrix(ord, i));
 
        ring_delete(&ord);
 
        return tab;
} 
 
 
t_void
anf_print_level_set(value)                      /* sets Anf print level */
        integer_small value;
{
        anf_print_level = value;
        return;
}
 
