/******************************************************************************
  anf_ideal_is_integral.c
******************************************************************************/
 
#include "stdio.h"        
#include "kant.h"
#include "anf.h"

t_logical
anf_ideal_is_integral WITH_2_ARGS(
	order,		ord,
	anf_ideal,	id
)
/*******************************************************************************
 
Description:
             
	Returns 1 if id is integral, 0 if it is not.
  
Calling sequence:
 
        anf_ideal_is_integral(ord, id);
 
        order   	ord:        order over which id is defined
        anf_ideal       id:	    ideal to be checked if integral
 
History:

	92-07-13 CO     first version

*******************************************************************************/
{       
	block_declarations;

	integer_small	intz, int2, maxx, t;
 

	order_must_be_over_z(ord);

	anf_ideal_simplify( ord, &id );


	if(anf_ideal_is_z(id))
	{
		if( integer_compare( anf_ideal_tran_den( id ), 1) == 0 )
			intz = 1;
		else
			intz = -1;
	}
	else
		intz = 0;


	if(anf_ideal_is_2(id))
	{
	    if( anf_elt_is_integer( anf_ideal_gen1( id )))
	    {
		if( anf_elt_is_integer( anf_ideal_gen2( id )))
		    int2 = 1;
		else
         	{
		    if( integer_compare( anf_elt_den( anf_ideal_gen2( id )), 1) == 0 )
			int2 = 1;
		    else
			int2 = -1;
		}
	    }
	    else     
	    {
		if( integer_compare( anf_elt_den( anf_ideal_gen1( id )), 1) == 0 )
         	{
		    if( anf_elt_is_integer( anf_ideal_gen2( id )))
			int2 = 1;
		    else
		    {
			if( integer_compare( anf_elt_den( anf_ideal_gen2( id )), 1) == 0 )
				int2 = 1;
			else
				int2 = -1;
		    }
		}
		else
		    int2 = -1;
	    }
	}
	else
		int2 = 0;


	if( anf_print_level > 7 )
		printf("\n anf_ideal_is_integral - flags: int_z=%d, int_2=%d",intz,int2);


	if( (intz + int2) == 0 )
		error_internal
		("anf_ideal_is_integral: ideal presentations not equivalent or not existing");


	maxx = (intz > int2) ? intz : int2;
	t   = (maxx  ==   1) ? 1    : 0   ;

	return t;
}

