/******************************************************************************
  anf_ideal_equal.c
******************************************************************************/
#include "kant.h"

t_logical
anf_ideal_equal WITH_3_ARGS (
	order,		ord,
	anf_ideal,	ia,
	anf_ideal,	ib
)
/******************************************************************************
 
Description:	Compares two ideals.
		    
Calling sequence:
 
	bool =	anf_ideal_equal(ord,ia,ib)
	     =	"(ia == ib)"

History:

	92-10-07 KW	written
 
******************************************************************************/
{
	block_declarations;

	anf_ideal_tran_assure_hnf_upper(ord,ia);
	anf_ideal_tran_assure_hnf_upper(ord,ib);

	return (!integer_compare(anf_ideal_tran_den(ia),anf_ideal_tran_den(ib))
		&& mat_z_equal(structure_z,anf_ideal_tran(ia),anf_ideal_tran(ib)));
}
