/******************************************************************************
  anf_ideal_add.c
******************************************************************************/
 
#include "kant.h"        

anf_ideal
anf_ideal_add WITH_3_ARGS(
	order,		ord,
	anf_ideal,	id1,
	anf_ideal,	id2
)
/*******************************************************************************
 
Description:
                                     
	We add the integral ideals id1 and id2.

  
Calling sequence:
 
        anf_ideal_add(ord, id1, id2);
 
        order   	ord:    order over which id1 and id2 are defined
        anf_ideal   id1,id2:	integral ideals

 
History:

	92-09-16 CO     first version

*******************************************************************************/
{       
	block_declarations;
	t_int		n;
	t_handle	Z;
	matrix		temp1, temp2, temp3, hnf, tran;
	anf_ideal	sum;

	order_must_be_over_z( ord );

	anf_ideal_z_assure( ord, id1 );
	anf_ideal_z_assure( ord, id2 );

	if( !(anf_ideal_is_integral( ord, id1 ) || anf_ideal_is_integral( ord, id2 )) )
		error_internal("anf_ideal_add: Ideal is not integral.");

	n = order_abs_degree( ord );
	Z = structure_z;

	temp1 = mat_new( n, 2*n );
	temp2 = mat_ring_insert( Z, temp1, anf_ideal_tran( id1 ), 1, 1 );
	temp3 = mat_ring_insert( Z, temp2, anf_ideal_tran( id2 ), 1, n+1 );

	hnf = mat_ring_hnf_col_upper( Z, temp3 );
	tran = mat_ring_submat( Z, hnf, 1, 1, n, n );

	sum = anf_ideal_z_create( ord, tran, 1 );
	anf_ideal_tran_hnf( sum ) = 1;
	
        mat_delref (Z,&tran);
        mat_delref (Z,&hnf);
        mat_delref (Z,&temp1);
        mat_delref (Z,&temp2);
        mat_delref (Z,&temp3);

	return( sum );
}
