/******************************************************************************
  anf_elt_power_product_mod.c
******************************************************************************/

#include "kant.h"
#include "anf.h"  


anf_elt
anf_elt_power_product_mod WITH_4_ARGS(
	order,		ord,
	integer_big,	modul,
	vector,		b,
	vector,		e
)

/******************************************************************************
 
Description:	Computes the power product

		    e[1]              e[n]
		b[1]     * .... * b[n]

		with respect to a given modul where
		b[1],...,b[n] are algebraic numbers
		The exponents e[1],...,e[n] must be positive integers.
 
Calling sequence:

	alpha = anf_elt_power_product_mod(ord,modul,b,e)

	alpha	=	result
	ord	=	order over which the entries of b are given
	modul	=	since we are computing something modular
			we need a modul. 
	b	=	vector whose entries are algebraic numbers
	e	=	vector whose entries are integer_bigs	 
 
History:
 
	92-05-26 KW	modular arithmetics
	92-05-05 KW	non-modular version: vectors instead of dynamical arrays
	92-04-23 KW	non-modular version: written
 
******************************************************************************/
{
	block_declarations;

	anf_elt		alpha,tempa,tempb;
	integer_small	i,n;

	n = vec_length(b);

	for (i=1;i<=n;i++)
	{
		if (anf_elt_is_con(vec_entry(b,i)))
			error_internal("anf_elt_power_product_mod: cannot deal conjugate vectors");
		if (integer_compare(vec_entry(e,i),0) == -1) 
			error_internal("anf_elt_power_product_mod: cannot deal negative exponents");
	}

	alpha = 1;
	for (i=1;i<=n;i++)
	{
		tempa = alpha;
		tempb = anf_elt_power_mod(ord,modul,vec_entry(b,i),vec_entry(e,i));
		alpha = anf_mult_mod(ord,modul,tempa,tempb);
		anf_elt_delete(ord,&tempa);
		anf_elt_delete(ord,&tempb);
	}

	return alpha;
}
