#include "kant.h"
#include "integer.e"
#include "mat.h"
#include "anf.h"

t_logical
anf_elt_in_ideal WITH_3_ARGS(
	order,		ord,
	anf_elt,	alpha,
	anf_ideal,	id

)
/*******************************************************************************
 
anf_elt_in_ideal.c
 
JS September 1991 
Last modification: 02.10.91
 
Checks whether the algebraic number alpha is contained in the fractional 
ideal id.
The ideal must be given in Z-basis presentation (upper Hermite normal form),
if not it will be converted.
The inclusion is checked by solving a system of linear equations recursively.
 
*******************************************************************************/
{
	block_declarations;

	integer_small	deg;
	integer_big	lcm, multid, multa, accu, temp0, temp1, rest, mini;
	matrix		trans;
 	integer_small	i, j;
	anf_elt		x;
                   
  
	order_must_be_over_z(ord);

	deg = order_rel_degree(ord);
 
	if(!anf_ideal_is_z(id)) anf_ideal_2_z(ord, id);
 
/*
    The method is only implemented for upper HNF of transition matrix
*/
 
        anf_ideal_tran_assure_hnf_upper( ord, id);
	if(anf_ideal_tran_hnf(id) < 1)
		error_internal("anf_elt_in_ideal: No upper HNF given.");
 
	trans = anf_ideal_tran(id);
  
/*
    Trivial case: alpha is integer. We have to care for denominators.
*/
    
	if (anf_elt_is_integer(alpha))
	{
                anf_ideal_min_assure( ord, id );
		mini = anf_ideal_min(id);
		if (mini)
		{
			temp0 = integer_mult(anf_ideal_tran_den(id), alpha);
			integer_quot_rem(temp0, mini, &temp1, &rest);
			integer_delref(temp0);
			integer_delref(temp1);
			if(rest)
			{
				integer_delref(rest);
				return FALSE;
			}
			else
			{
				return TRUE;
			}
		}
		else
		{
			error_internal("anf_elt_in_ideal: No minimum given.");
		}
	}
	
/*
    General case, first handling of denominators
*/			
 
	lcm = integer_lcm(anf_ideal_tran_den(id), anf_elt_den(alpha));
	multid = integer_div(lcm, anf_ideal_tran_den(id));
	multa  = integer_div(lcm, anf_elt_den(alpha));
 
/* 
    x will contain the coefficients of alpha referring to the ideal basis.
*/
	anf_elt_alloc(x, deg);
  
/*
    Now we compute x recursively, using the coefficients already computed.
*/
	for (i=deg; i>0; --i)
	{
		accu = 0;
 
		for (j=i+1; j<=deg; ++j)
		{
			temp0 = accu;
			temp1 = integer_mult(mat_elt(trans, i, j), 
						anf_elt_coef(x, j));
			accu  = integer_add(temp0, temp1);
 
			integer_delref(temp0);
			integer_delref(temp1);
		}
 
		temp0 = accu;
		accu  = integer_mult(multid, temp0);
		integer_delref(temp0);
                                      
		temp0 = integer_mult(anf_elt_coef(alpha, i), multa);
		temp1 = integer_subtract(temp0, accu);
		integer_delref(temp0);
 
		temp0 = integer_mult(mat_elt(trans, i, i), multid);
		integer_quot_rem(temp1, temp0, &anf_elt_coef(x, i), &rest);
 
		integer_delref(temp0);
		integer_delref(temp1);
 
		if(rest)
		{
			integer_delref(rest);
 			anf_elt_delete(ord, &x);
			return FALSE;
		}
 	}
 
	anf_elt_delete(ord, &x);
 
	return TRUE;
}
